% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_one_group.R
\name{plot_one_group}
\alias{plot_one_group}
\title{Plot output from boot_sample}
\arguments{
\item{x}{Output from boot_one function.}

\item{n_max}{Numeric. Maximum sample size to extrapolate simulations.}

\item{n_min}{Numeric. Minimum sample size to extrapolate simulations.
Defaults to 3.}

\item{colour_exp}{Colour of the experimental data. Defaults to "blue".}

\item{colour_extrap}{Colour of the extrapolated data. Defaults to "red".}

\item{legend.position}{Position of the legend. Defaults to "top". Can be "bottom", "left", "right", or "none".}

\item{alpha_val}{Change the degree of shading of the graphs. Default is 0.2.}

\item{ggtheme}{The theme for the ggplot created. See ggplot2 themes for options. Default set to theme_classic().}
}
\value{
Two plots; (a) precision of the CTmin estimate across experimental and extrapolated sample sizes; (b)
the sampling distribution (range of plausible CTmin values) across experimental and extrapolated sample sizes.
}
\description{
Plot output from boot_one.
}
\examples{
\donttest{
sims <- boot_one(coreid_data,
                    groups_col = col,
                    groups_which = "Catorhintha schaffneri_APM",
                    n_max = 30,
                    response = response)
plot_one_group(x = sims,
               n_min = 3,
               n_max = 15,
               colour_exp = "darkblue",
               colour_extrap = "green",
               legend.position = "right")
}
}
