% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pMatrix.R
\name{pMatrix}
\alias{pMatrix}
\title{Visualization Of t-Greene Pairwise Comparisons}
\usage{
pMatrix(x = NULL, Pop = 1, lower_tail = FALSE, tail = "two",
  padjust = "none", plot = FALSE, ...)
}
\arguments{
\item{x}{Data frame containing summary statistics of both sexes for two or
more populations, Default: NULL}

\item{Pop}{Number of the column containing populations' names, Default: 1}

\item{lower_tail}{Logical; if \code{TRUE} probabilities are \code{P[X <= x]},
otherwise, \code{P[X > x]}, Default: FALSE}

\item{tail}{Number of t test tails, Default: 'two'}

\item{padjust}{padjust Method of p value adjustment for multiple comparisons
following \code{p.adjust.methods}, Default: 'none'}

\item{plot}{Logical;if \code{TRUE} graphical matrix of p-values, Default:
\code{TRUE}}

\item{...}{additional arguments that can be passed to
\link[corrplot]{corrplot} function.}
}
\value{
Graphical or numerical matrix of p-values from Greene t-test pairwise
  comparisons.
}
\description{
Returns a graphical or numerical correlational matrix of
  p-values for the interpopulation degree of sexual dimorphism as measured by
  Greene t-test
}
\details{
Data is entered in a wide format with each row representing a given
  population.\code{Pop}  (first column by default) contains population names,
  \code{.mu} and \code{.sdev} contain means and standard deviations with
  \code{M} and \code{F} donating males and females respectively. While
  \code{m}&\code{f} are the male and female sample sizes.When more than two
  populations are tested,\code{p.adjust.methods:
  c('holm','hochberg','hommel','bonferroni','BH','BY','fdr','none')} can be
  used for p value adjustment.
}
\examples{
 # Comparisons of femur head diameter in four populations
library(TestDimorph)
m <- c(150.00, 82.00, 36.00, 34.00)
f <- c(150.00, 58.00, 34.00, 24.00)
M.mu <- c(49.39, 48.33, 46.99, 45.20)
F.mu <- c(42.91, 42.89, 42.44, 40.90)
M.sdev <- c(3.01, 2.53, 2.47, 2.00)
F.sdev <- c(2.90, 2.84, 2.26, 2.90)
df <- cbind.data.frame(
  Pop = c('Turkish', 'Bulgarian', 'Greek', 'Portuguese '),
  m,
  f,
  M.mu,
  F.mu,
  M.sdev,
  F.sdev,
  stringsAsFactors = TRUE
)
pMatrix(x = df,plot=TRUE,method = 'ellipse', type = 'lower', col = c('#AEB6E5',
'#B1A0DB', '#B788CD', '#BC6EB9', '#BC569E', '#B6407D', '#A93154'), is.corr =
FALSE, tl.cex = 0.8, tl.col = 'black', sig.level = 0.05,insig =
'label_sig', pch.cex = 2.5, tl.pos = 'ld', win.asp = 1, tl.srt =
0.1,number.cex = 0.5, na.label = 'NA')

}
\references{
\insertRef{timonov2014study}{TestDimorph}

  \insertRef{curate2017sex}{TestDimorph}

  \insertRef{kranioti2009sex}{TestDimorph}

  \insertRef{gulhan2015new}{TestDimorph}
}
