% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tINV.R
\name{tINV}
\alias{tINV}
\title{Performs inverse of 3-mode tensor using any discrete transform.}
\usage{
tINV(tnsr, tform)
}
\arguments{
\item{tnsr, }{a 3-mode tensor S3 class object}

\item{tform, }{Any discrete transform.
fft: Fast Fourier Transorm
dwt: Discrete Wavelet Transform (Haar Wavelet)
dct: Discrete Cosine transform
dst: Discrete Sine transform
dht: Discrete Hadley transform
dwht: Discrete Walsh-Hadamard transform}
}
\value{
S3 class tensor
}
\description{
Performs inverse of 3-mode tensor using any discrete transform.
}
\examples{
T <- t_rand(modes=c(2,2,4))
print(tINV(T,"dst"))
}
\author{
Kyle Caudle

Randy Hoover

Jackson Cates

Everett Sandbo
}
