% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS.R
\name{qNTS}
\alias{qNTS}
\title{Quantile function of the normal tempered stable (NTS)}
\usage{
qNTS(
  p,
  alpha = NULL,
  beta = NULL,
  delta = NULL,
  lambda = NULL,
  mu = NULL,
  theta = NULL,
  qmin = NULL,
  qmax = NULL,
  ...
)
}
\arguments{
\item{p}{A numeric vector of probabilities. Each probability must be a real
number >0 and <1.}

\item{alpha}{A real number between 0 and 1.}

\item{beta}{A gap holder.}

\item{delta}{A real number > 0.}

\item{lambda}{A  real number >= 0.}

\item{mu}{A location parameter, any real number.}

\item{theta}{A vector of all other arguments.}

\item{qmin, qmax}{Limits of the interval. Will be computed if
\code{==NULL}.}

\item{...}{Modify \code{\link[=pNTS]{pNTS()}} and \code{\link[stats:uniroot]{stats::uniroot()}}.}
}
\value{
As \code{p} is a numeric vector, the return value is also a numeric
vector of quantiles.
}
\description{
The quantile function of the normal tempered stable (NTS).
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, beta, delta, lambda,
mu)}. Either provide the parameters individually OR provide \code{theta}.
The function searches for a root between \code{qmin} and \code{qmax} with
\code{uniroot}.
Boundaries can either be supplied by the user or a built-in approach using
the stable distribution is used.
}
\examples{
\donttest{
qNTS(0.1,0.5,1,1,1,1)
qNTS(0.3,0.6,1,1,1,1,NULL)
}

}
\seealso{
See also the \code{\link[=pNTS]{pNTS()}} probability function.
}
