% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS.R
\name{charCTS}
\alias{charCTS}
\title{Characteristic function of the classical tempered stable (CTS) distribution}
\usage{
charCTS(
  t,
  alpha = NULL,
  deltap = NULL,
  deltam = NULL,
  lambdap = NULL,
  lambdam = NULL,
  mu = NULL,
  theta = NULL
)
}
\arguments{
\item{t}{A vector of real numbers where the CF is evaluated.}

\item{alpha}{Stability parameter. A real number between 0 and 2.}

\item{deltap}{Scale parameter for the right tail. A real number > 0.}

\item{deltam}{Scale parameter for the left tail. A real number > 0.}

\item{lambdap}{Tempering parameter for the right tail. A real number > 0.}

\item{lambdam}{Tempering parameter for the left tail. A real number > 0.}

\item{mu}{A location parameter, any real number.}

\item{theta}{Parameters stacked as a vector.}
}
\value{
The CF of the tempered stable subordinator distribution.
}
\description{
Theoretical characteristic function (CF) of the classical tempered
stable distribution. See Kuechler & Tappe (2013) for details.
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, deltap, deltam,
lambdap, lambdam, mu)}. Either provide the parameters individually OR
provide \code{theta}.
\deqn{\varphi_{CTS}(t;\theta):=
E_{\theta}\left[
\mathrm{e}^{\mathrm{i}tX}\right]=
\exp\left(\mathrm{i}t\mu+\delta_+\Gamma(-\alpha)
\left((\lambda_+-\mathrm{i}t)^{\alpha}-\lambda_+^{\alpha}+
\mathrm{i}t\alpha\lambda_+^{\alpha-1}\right)\right.\\}
\deqn{\left. +\delta_-\Gamma(-\alpha)
\left((\lambda_-+\mathrm{i}t)^{\alpha}-\lambda_-^{\alpha}-\mathrm{i}t\alpha
\lambda_-^{\alpha-1}\right)
\right)}
}
\examples{
x <- seq(-10,10,0.25)
y <- charCTS(x,1.5,1,1,1,1,0)

}
\references{
Massing, T. (2023), 'Parametric Estimation of Tempered Stable Laws'

Kuechler, U. & Tappe, S. (2013), 'Tempered stable distributions and
processes' \doi{10.1016/j.spa.2013.06.012}
}
