% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaMap.r
\name{BaMap}
\alias{BaMap}
\title{function for mapping the 36 tree species to several internal functions}
\usage{
BaMap(Ba = NULL, type = NULL)
}
\arguments{
\item{Ba}{BDAT tree number}

\item{type}{a number referring to the type to be mapped}
}
\value{
value(s), either a scalar, vector or matrix, with respect to tree
species mapping to functions
}
\description{
function for mapping the 36 tree species to several internal functions
}
\details{
c.f. BDAT source code, line 7622, data block Ban(36, 7)
type 1: Schaftform // taper form
type 2: Rinde // bark
type 3: Durchschnittliche Aufarbeitungsgrenze (nach EST) //average cutting diameter
type 4: Höhe unverwertbares Derbholz // percentage non-merchantable coarse wood
type 5: durchschnittlicher Astdurchmesser in der Krone // average branch diameter inside crown
type 6: BWI-Biomasse-Funktionen // NFI-biomass functions according to Riedel & Kändler (2017)
type 7: kompartimentweise Biomassefunktionen // component biomass functions according to Vonderach et al (2018)
type 8: Zuordnung zu volfao // Mapping to volume according to FAO (FIX: mapping still temporary)
Not included: volume tables according to Grundner and Schwappach as well as
volume tables according to Krenn for small trees below 10cm dbh
}
\examples{
BaMap(1,1) # which taper form for Norway spruce
BaMap(15,1) # which taper form for European Beech
BaMap(15,2) # which bark equation for European Beech
BaMap(,1) # return all taper form mappings
BaMap(1,) # return all mappings for Norway spruce
BaMap() # return all mappings
BaMap(, 6) # biomass mapping
BaMap(, 7) # component biomass functions
BaMap(, 8) # mapping for Vol_FAO
}
