% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidth.R
\name{silverman}
\alias{silverman}
\title{Compute Bandwidth Parameter Using Silverman's Rule of Thumb}
\usage{
silverman(returns)
}
\arguments{
\item{returns}{A numeric matrix of asset returns with \eqn{T} rows (time periods) and \eqn{p} columns (assets).}
}
\value{
A numeric value representing the computed bandwidth parameter based on Silverman's rule.
}
\description{
This function calculates the bandwidth parameter for kernel functions using Silverman's rule of thumb,
which is commonly used in kernel density estimation to determine an appropriate bandwidth. The procedure is available either as a 
stand-alone function or as a method in the `TVMVP` R6 class.
}
\details{
Silverman's rule of thumb for bandwidth selection is given by:
\deqn{bandwidth = \frac{2.35}{\sqrt{12}} \times T^{-0.2} \times p^{-0.1}}
where \eqn{T} is the number of time periods and \eqn{p} is the number of assets.

Two usage styles:

\preformatted{
# Function interface
bw <- silverman(returns)

# R6 method interface
tv <- TVMVP$new()
tv$set_data(returns)
tv$silverman()
}
}
\examples{
# Simulate data for 50 assets over 200 time periods
set.seed(123)
T <- 200
p <- 50
returns <- matrix(rnorm(T * p, mean = 0.001, sd = 0.02), ncol = p)

# Compute bandwidth using Silverman's rule of thumb
bw <- silverman(returns)
print(bw)

tv <- TVMVP$new()
tv$set_data(returns)
tv$silverman()

}
