% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesis_testing.R
\name{compute_M_hat}
\alias{compute_M_hat}
\title{Compute \eqn{M_{\hat{}}} Statistic for Covariance Time-Variation Hypothesis Testing}
\usage{
compute_M_hat(
  local_factors,
  global_factors,
  local_loadings,
  global_loadings,
  iT,
  ip,
  m
)
}
\arguments{
\item{local_factors}{A list where each element is a numeric matrix representing the
local factor scores for a specific time period. Each matrix should have \eqn{T} rows
(time periods) and \eqn{m} columns (factors).}

\item{global_factors}{A numeric matrix of global factor scores with \eqn{T} rows
(time periods) and \eqn{m} columns (factors).}

\item{local_loadings}{A list where each element is a numeric matrix representing the
local factor loadings for a specific time period. Each matrix should have \eqn{N}
rows (assets) and \eqn{m} columns (factors).}

\item{global_loadings}{A numeric matrix of global factor loadings with \eqn{N} rows
(assets) and \eqn{m} columns (factors).}

\item{iT}{An integer specifying the number of time periods.}

\item{ip}{An integer specifying the number of assets.}

\item{m}{An integer specifying the number of factors.}
}
\value{
A numeric scalar \eqn{M_{\hat{}}} representing the average squared discrepancy
between local and global factor models across all assets and time periods.
}
\description{
This function calculates the \eqn{M_{\hat{}}} statistic, which measures the average squared
discrepancy between local and global factor models across all assets and time periods.
It quantifies the difference between locally estimated factors/loadings and their global
counterparts.
}
\details{
The function performs the following steps:
\enumerate{
  \item Initializes the \eqn{M_{\hat{}}} statistic to zero.
  \item If the number of factors \eqn{m} is equal to one, it ensures that
  \code{global_loadings} and \code{global_factors} are treated as matrices.
  \item Iterates over each asset \eqn{i = 1} to \eqn{N} and each time period \eqn{t = 1} to \eqn{T}.
  \item For each asset and time period, computes:
  \itemize{
    \item \code{common_H1}: The dot product of the local loadings and local factors.
    \item \code{common_H0}: The dot product of the global loadings and global factors.
    \item The squared difference \eqn{(common\_H1 - common\_H0)^2} and adds it to \eqn{M_{\hat{}}}.
  }
  \item After all iterations, normalizes \eqn{M_{\hat{}}} by dividing by the product of \eqn{N} and \eqn{T}.
}
}
\keyword{internal}
