% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast_tools.R
\name{forecast_sim}
\alias{forecast_sim}
\title{Forecasting simulation}
\usage{
forecast_sim(model, h, n, sim_color = "blue", opacity = 0.05, plot = TRUE)
}
\arguments{
\item{model}{A forecasting model supporting \code{\link[forecast]{Arima}}, \code{\link[forecast]{auto.arima}}, 
\code{\link[forecast]{ets}}, and \code{\link[forecast]{nnetar}} models from the **forecast** package}

\item{h}{An integer, defines the forecast horizon}

\item{n}{An integer, set the number of iterations of the simulation}

\item{sim_color}{Set the color of the simulation paths lines}

\item{opacity}{Set the opacity level of the simulation path lines}

\item{plot}{Logical, if TRUE will desplay the output plot}
}
\value{
The baseline series, the simulated values and a plot
}
\description{
Creating different forecast paths for forecast objects (when applicable), 
by utilizing the underline model distribution with the \code{\link[stats]{simulate}} function
}
\examples{
 \dontrun{
library(forecast)
data(USgas)

# Create a model
fit <- auto.arima(USgas)

# Simulate 100 possible forecast path, with horizon of 60 months
forecast_sim(model = fit, h = 60, n = 100)
}
}
