% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tree_object.R
\name{get_tree_object}
\alias{get_tree_object}
\title{Tree-guided reparameterization}
\usage{
get_tree_object(
  X_2,
  treemat,
  penalty = c("CL2", "DL2", "RFS-Sum"),
  group.weight = NULL,
  feature.weight = NULL
)
}
\arguments{
\item{X_2}{Expanded design matrix for \code{penalty = "CL2"};
Original design matrix
for \code{penalty = "RFS-Sum"}. Need to be in the matrix form.}

\item{treemat}{Expanded tree structure for
\code{penalty = "CL2"}; Original structure for \code{penalty = "RFS-Sum"}.
Need to be in the matrix form.}

\item{penalty}{Two options for group penalty on \eqn{\gamma},
"CL2" or "RFS-Sum".}

\item{group.weight}{User-defined weights for group penalty.
Need to be a vector and the length equals to the number of groups.}

\item{feature.weight}{User-defined weights for each predictor
after expansion.}
}
\value{
A list consists of quantities needed for SPG optimization.
\item{C_1}{C_1 matrix for generalized lasso penalty.}
\item{CNorm_1}{Nuclear norm of matrix \code{C_1}.}
\item{C_2}{C_2 matrix for group lasso penalty.}
\item{CNorm_2}{Nuclear norm of matrix \code{C_2}.}
\item{A}{A (number-of-leaf * number-of-node) binary matrix containing linear constraints.
Recall that \eqn{\beta=A\gamma}.
It is used with \code{beta.coef} and \code{x.expand}.}
\item{g_idx}{A (number-of-group * 3) matrix.
Each column stands for starting row in \code{C_2} of a group,
end row in \code{C_2} of a group, and the group size.}
\item{M2}{A (number-of-leaf * number-of-level) node index matrix,
with index going from 1 to the number of nodes.
Root node has index equal to the number of nodes.
Each row corresponds to a variable at the finest level,
each column corresponds to an ordered classification level;
the entry values in each column are the unique indices of the variables
at that level.
As we move to the right, the number of unique values becomes fewer.}
\item{Tree}{A (number-of-group *  number-of-node) group index matrix.
Each row is a group and the column order is the same as the order of node
index in M2. If the jth node belongs to the ith group, then the (i, j)
element of the matrix is 1; otherwise the element is 0.}
\item{A.adj}{A (number-of-leaf * number-of-node) binary matrix
containing linear constraints.
It is used with \code{beta.coef.adj} and \code{x.expand.adj}.}
}
\description{
This function generates all the intermediate quantities
based on the tree-guided reparameterization.
}
