% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPMplt.R
\name{TPM2dplt}
\alias{TPM2dplt}
\title{Plot 2d thermal process maps}
\usage{
TPM2dplt(x, xloc = 0.09, yloc = 0.03, lowclr = "red",
  mdclr = "white", highclr = "green")
}
\arguments{
\item{x}{Regression results from modeling functions such as \code{\link[TPMplt:SVRModel]{SVRModel}}.}

\item{xloc}{Location for annotatin in x axis. The default value is 0.09.}

\item{yloc}{Location for annotatin in y axis. The default value is 0.03.}

\item{lowclr}{Colour for low rheological stability region. The default setting is "red".}

\item{mdclr}{Colour between low and high rheological stability regions. The default setting uses "white".}

\item{highclr}{Colour for high rheological stability region. The default setting is "green".}
}
\value{
A 2d thermal processing-map with logarithm strain rate as its y axis while celsius temperature as its x axis. Strain conditon
is showed in top-left in the figure. Power dissipation efficiency factor eta is denoted by gradient blue contours, and the rheological
stability coefficient are represented by gradient background.
}
\description{
Plot a 2d thermal process maps: logarithm strain rate as y axis while celsius temperature as x axis. Contours denotes
the power dissipation efficiency factor, while the background with gradual colors represents rheological stability.
}
\examples{
epstable <- epsExtract(TPMdata, 0.7, 2, 3)
DMM <- DMMprocess(epstable)
PLTbd <- SVRModel(DMM)
TPM2dplt(PLTbd)
}
\keyword{PLTbuilder}
\keyword{Processing-map}
