% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalTuningParam.R
\name{evalTuningParam}
\alias{evalTuningParam}
\title{Evaluate TPLS tuning parameters using cross validation}
\usage{
evalTuningParam(
  TPLScvmdl,
  type = c("pearson", "spearman", "AUC"),
  X,
  Y,
  compvec,
  threshvec,
  subfold = NULL
)
}
\arguments{
\item{TPLScvmdl}{TPLS_cv model created from \code{TPLS_cv}}

\item{type}{Cross validation performance measure type. One of 'pearson', 'spearman', or 'AUC'}

\item{X}{The SAME X that was used to create the \code{TPLScvmdl}. If it's not the same, the function may not work or the results will be completely off}

\item{Y}{The SAME Y that was used to create the \code{TPLScvmdl}.}

\item{compvec}{Vector containing the number of components you want to assess CV performance for (e.g., c(3,4,5) will provide CV performance of 3, 4, and 5 component TPLS model at various thresholds)}

\item{threshvec}{Vector containing the thresholding level betweeon 0 and 1 you want to assess CV performance for (e.g., seq(0,1,0.1) will provide CV performance of TPLS models at thresholds of 0, 0.1, 0.2, ... ,1)}

\item{subfold}{Optional vector containing smaller data division within folds. For example, if the cross-validation was done at the subject level, with each testing fold being a subject,
subfold can be the run number of the scan of each person. This allows for calculation of average CV metric at the run level instead of at the subject level.}
}
\value{
A evalTuningParam object that contains the following attributes.
\itemize{
    \item \code{type}: Cross validation performance measure type, as specified in the input
    \item \code{threshval}: Same as the input threshvec
    \item \code{compval}: Same as the input compvec
    \item \code{perfmat}: Performance measure 3D matrix: length(compvec)-by-length(threshvec)-by-numfold
    \item \code{perf_best}: Best CV performance out of all combinations of compvec and threshvec
    \item \code{compval_best}: Number of components that gave the best performance (i.e., perf_best)
    \item \code{threshval_best}: Threshold level that gave the best performance (i.e., perf_best)
    \item \code{perf_1se} : Performance of the most parsimonious model (least number of coefficients) that is within 1 standard error of perf_best.
    \item \code{compval_1se} : Number of components that gave perf_1se
    \item \code{threshval_1se} : Threshold level that gave perf_1se
}
}
\description{
Evaluate TPLS tuning parameters using cross validation
}
\examples{
# see examples under TPLS_cv as you'd need a TPLS_cv object to run this function
}
