% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chord_plot.R
\name{chord_plot}
\alias{chord_plot}
\title{Chord plot for visualizing the relationships of pathways and genes.}
\usage{
chord_plot(
  data,
  multi_colors = "VividColors",
  color_seed = 10,
  color_alpha = 0.3,
  link_visible = TRUE,
  link_dir = -1,
  link_type = "diffHeight",
  sector_scale = "Origin",
  width_circle = 3,
  dist_name = 3,
  label_dir = "Vertical",
  dist_label = 0.3,
  label_scale = 0.8
)
}
\arguments{
\item{data}{Dataframe: Shared DEGs of all paired comparisons in all samples expression dataframe of RNA-Seq. (1st-col: Genes, 2nd-col~: Samples).}

\item{multi_colors}{Character: color palette. Default: "VividColors", options: "VividColors", "RainbowColors".}

\item{color_seed}{Numeric: rand seed for VividColors. Default: 10.}

\item{color_alpha}{Numeric: color alpha. Default: 0.50, min: 0.00, max: 1.00.}

\item{link_visible}{Logical: links visible. Default: TRUE, options: TRUE, FALSE.}

\item{link_dir}{Numeric: links direction, use with link_type. Default: -1, options: -1, 0, 1, 2.}

\item{link_type}{Character: links type, use with link_dir. Default: "diffHeight", options: "diffHeight", "arrows".}

\item{sector_scale}{Character: sector scale method. Default: "Origin", options: "Origin", "Scale".}

\item{width_circle}{Numeric: outside circle width. Default: 3.0, min: 0.0, max: 10.0.}

\item{dist_name}{Numeric: the distance of name and circle. Default: 3.0, min: 0.0, max: 10.0.}

\item{label_dir}{Character: label director. Default: "Vertical", options: "Horizontal", "Vertical".}

\item{dist_label}{Numeric: the distance of label and circle. Default: 0.3, min: 0.0.}

\item{label_scale}{Numeric: labels font size sclae. Default: 0.8, min: 0, max: NULL.}
}
\value{
Plot: chord plot is used to visualize complex relationships between samples and genes, as well as between pathways and genes.
}
\description{
Chord plot is used to visualize complex relationships between samples and genes, as well as between pathways and genes.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(gene_expression2)
head(gene_expression2)

# 3. Default parameters
chord_plot(gene_expression2[1:20,])

}
\author{
benben-miao
}
