% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kegg_enrich.R
\name{kegg_enrich}
\alias{kegg_enrich}
\title{KEGG enrichment analysis based on KEGG annotation results (None/Exist Reference Genome).}
\usage{
kegg_enrich(
  kegg_anno,
  kegg_deg_fc,
  padjust_method = "fdr",
  pvalue_cutoff = 1,
  qvalue_cutoff = 1
)
}
\arguments{
\item{kegg_anno}{Dataframe: include columns (id, kegg_pathway),  symbol ";" split ko pathways.}

\item{kegg_deg_fc}{Dataframe: include columns (id, log2FC).}

\item{padjust_method}{Character: P-value adjust to Q-value. Default: "fdr" (false discovery rate), options: "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none".}

\item{pvalue_cutoff}{Numeric: P-value cutoff. Recommend: small than 0.05.}

\item{qvalue_cutoff}{Numeric: Q-value cutoff. Recommend: small than 0.05.}
}
\value{
Table: include columns ("ID", "Description", "GeneRatio", "BgRatio", "pvalue", "p.adjust", "qvalue", "geneID", "Count").
}
\description{
KEGG enrichment analysis based on KEGG annotation results (None/Exist Reference Genome).
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(kegg_anno)
head(kegg_anno)

data(kegg_deg_fc)
head(kegg_deg_fc)

# 3. Default parameters
res <- kegg_enrich(kegg_anno, kegg_deg_fc)
head(res)

# 4. Set padjust_method = "BH"
res <- kegg_enrich(kegg_anno, kegg_deg_fc, padjust_method = "BH")
head(res)

# 5. Set pvalue_cutoff = 0.80
res <- kegg_enrich(kegg_anno, kegg_deg_fc, pvalue_cutoff = 0.80)
head(res)

}
\author{
benben-miao
}
