% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_t_test.R
\name{boot_t_test}
\alias{boot_t_test}
\alias{boot_t_test.default}
\alias{boot_t_test.formula}
\title{Bootstrapped t-test}
\usage{
boot_t_test(x, ...)

\method{boot_t_test}{default}(
  x,
  y = NULL,
  var.equal = FALSE,
  paired = FALSE,
  alternative = c("two.sided", "less", "greater", "equivalence", "minimal.effect"),
  mu = 0,
  alpha = 0.05,
  R = 1999,
  ...
)

\method{boot_t_test}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{...}{further arguments to be passed to or from methods.}

\item{y}{an optional (non-empty) numeric vector of data values.}

\item{var.equal}{a logical variable indicating whether to treat the two variances as being equal. If TRUE then the pooled variance is used to estimate the variance otherwise the Welch (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{paired}{a logical indicating whether you want a paired t-test.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater", "less", "equivalence" (TOST), or "minimal.effect" (TOST). You can specify just the initial letter.}

\item{mu}{a number specifying an optional parameter used to form the null hypothesis. See ‘Details’.}

\item{alpha}{alpha level (default = 0.05)}

\item{R}{number of bootstrap replicates}

\item{formula}{a formula of the form lhs ~ rhs where lhs is a numeric variable giving the data values and rhs either 1 for a one-sample or paired test or a factor with two levels giving the corresponding groups. If lhs is of class "Pair" and rhs is 1, a paired test is done.}

\item{data}{an optional matrix or data frame (or similar: see model.frame) containing the variables in the formula formula. By default the variables are taken from environment(formula).}

\item{subset}{an optional vector specifying a subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when the data contain NAs. Defaults to getOption("na.action").}
}
\value{
A list with class \code{"htest"} containing the following components:
\itemize{
\item "statistic": the value of the t-statistic.
\item "parameter": the degrees of freedom for the t-statistic.
\item "p.value": the p-value for the test.
\item "conf.int": a confidence interval for the mean appropriate to the specified alternative hypothesis.
\item "estimate": the estimated mean or difference in means depending on whether it was a one-sample test or a two-sample test.
\item "null.value": the specified hypothesized value of the mean or mean difference. May be 2 values.
\item "stderr": the standard error of the mean (difference), used as denominator in the t-statistic formula.
\item "alternative": a character string describing the alternative hypothesis.
\item "method": a character string indicating what type of t-test was performed.
\item "data.name": a character string giving the name(s) of the data.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A function for a bootstrap method for t-tests.
}
\details{
The implemented test(s) corresponds to the proposal of Chapter 16 of Efron and Tibshirani (1994).

For two-sample tests, the test is of \eqn{\bar x - \bar y} (mean of x minus mean of y).
For paired samples, the test is of the difference scores (z),
wherein \eqn{z =  x - y}, and the test is of \eqn{\bar z} (mean of the difference scores).
For one-sample tests, the test is of \eqn{\bar x } (mean of x).

For details on the calculations in this function see \code{vignette("robustTOST")}.
}
\section{References}{


Efron, B., & Tibshirani, R. J. (1994). An introduction to the bootstrap. CRC press.
}

\examples{
# example code

boot_t_test(extra ~ group, data = sleep)
}
\seealso{
Other Robust tests: 
\code{\link{boot_log_TOST}()},
\code{\link{boot_t_TOST}()},
\code{\link{brunner_munzel}()},
\code{\link{log_TOST}()},
\code{\link{wilcox_TOST}()}
}
\concept{Robust tests}
