
# This file is automatically generated, you probably don't want to edit this

dataTOSTpairedOptions <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "dataTOSTpairedOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            pair1 = NULL,
            pair2 = NULL,
            hypothesis = "EQU",
            low_eqbound = -0.5,
            high_eqbound = 0.5,
            eqbound_type = "raw",
            alpha = 0.05,
            desc = FALSE,
            plots = FALSE,
            low_eqbound_dz = -999999999,
            high_eqbound_dz = -999999999,
            indplot = FALSE,
            diffplot = FALSE,
            smd_type = "g", ...) {

            super$initialize(
                package="TOSTER",
                name="dataTOSTpaired",
                requiresData=TRUE,
                ...)

            private$..pair1 <- jmvcore::OptionVariable$new(
                "pair1",
                pair1,
                permitted=list(
                    "numeric"),
                suggested=list(
                    "continuous"))
            private$..pair2 <- jmvcore::OptionVariable$new(
                "pair2",
                pair2,
                permitted=list(
                    "numeric"),
                suggested=list(
                    "continuous"))
            private$..hypothesis <- jmvcore::OptionList$new(
                "hypothesis",
                hypothesis,
                options=list(
                    "EQU",
                    "MET"),
                default="EQU")
            private$..low_eqbound <- jmvcore::OptionNumber$new(
                "low_eqbound",
                low_eqbound,
                default=-0.5)
            private$..high_eqbound <- jmvcore::OptionNumber$new(
                "high_eqbound",
                high_eqbound,
                default=0.5)
            private$..eqbound_type <- jmvcore::OptionList$new(
                "eqbound_type",
                eqbound_type,
                options=list(
                    "SMD",
                    "raw"),
                default="raw")
            private$..alpha <- jmvcore::OptionNumber$new(
                "alpha",
                alpha,
                min=0,
                max=1,
                default=0.05)
            private$..desc <- jmvcore::OptionBool$new(
                "desc",
                desc,
                default=FALSE)
            private$..plots <- jmvcore::OptionBool$new(
                "plots",
                plots,
                default=FALSE)
            private$..low_eqbound_dz <- jmvcore::OptionNumber$new(
                "low_eqbound_dz",
                low_eqbound_dz,
                default=-999999999,
                hidden=TRUE)
            private$..high_eqbound_dz <- jmvcore::OptionNumber$new(
                "high_eqbound_dz",
                high_eqbound_dz,
                default=-999999999,
                hidden=TRUE)
            private$..indplot <- jmvcore::OptionBool$new(
                "indplot",
                indplot,
                default=FALSE)
            private$..diffplot <- jmvcore::OptionBool$new(
                "diffplot",
                diffplot,
                default=FALSE)
            private$..smd_type <- jmvcore::OptionList$new(
                "smd_type",
                smd_type,
                options=list(
                    "d",
                    "g"),
                default="g")

            self$.addOption(private$..pair1)
            self$.addOption(private$..pair2)
            self$.addOption(private$..hypothesis)
            self$.addOption(private$..low_eqbound)
            self$.addOption(private$..high_eqbound)
            self$.addOption(private$..eqbound_type)
            self$.addOption(private$..alpha)
            self$.addOption(private$..desc)
            self$.addOption(private$..plots)
            self$.addOption(private$..low_eqbound_dz)
            self$.addOption(private$..high_eqbound_dz)
            self$.addOption(private$..indplot)
            self$.addOption(private$..diffplot)
            self$.addOption(private$..smd_type)
        }),
    active = list(
        pair1 = function() private$..pair1$value,
        pair2 = function() private$..pair2$value,
        hypothesis = function() private$..hypothesis$value,
        low_eqbound = function() private$..low_eqbound$value,
        high_eqbound = function() private$..high_eqbound$value,
        eqbound_type = function() private$..eqbound_type$value,
        alpha = function() private$..alpha$value,
        desc = function() private$..desc$value,
        plots = function() private$..plots$value,
        low_eqbound_dz = function() private$..low_eqbound_dz$value,
        high_eqbound_dz = function() private$..high_eqbound_dz$value,
        indplot = function() private$..indplot$value,
        diffplot = function() private$..diffplot$value,
        smd_type = function() private$..smd_type$value),
    private = list(
        ..pair1 = NA,
        ..pair2 = NA,
        ..hypothesis = NA,
        ..low_eqbound = NA,
        ..high_eqbound = NA,
        ..eqbound_type = NA,
        ..alpha = NA,
        ..desc = NA,
        ..plots = NA,
        ..low_eqbound_dz = NA,
        ..high_eqbound_dz = NA,
        ..indplot = NA,
        ..diffplot = NA,
        ..smd_type = NA)
)

dataTOSTpairedResults <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "dataTOSTpairedResults",
    inherit = jmvcore::Group,
    active = list(
        text = function() private$.items[["text"]],
        tost = function() private$.items[["tost"]],
        eqb = function() private$.items[["eqb"]],
        effsize = function() private$.items[["effsize"]],
        desc = function() private$.items[["desc"]],
        plots = function() private$.items[["plots"]],
        indplot = function() private$.items[["indplot"]],
        diffplot = function() private$.items[["diffplot"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="TOST Paired Samples T-Test")
            self$add(jmvcore::Html$new(
                options=options,
                name="text",
                clearWith=list(
                    "mu",
                    "alpha",
                    "var_equal",
                    "hypothesis",
                    "low_eqbound",
                    "high_eqbound",
                    "eqbound_type")))
            self$add(jmvcore::Table$new(
                options=options,
                name="tost",
                title="TOST Results",
                visible=TRUE,
                rows=3,
                clearWith=list(
                    "alpha",
                    "low_eqbound",
                    "high_eqbound",
                    "eqbound_type",
                    "pair1",
                    "pair2"),
                columns=list(
                    list(
                        `name`="i1", 
                        `title`="", 
                        `type`="text"),
                    list(
                        `name`="i2", 
                        `title`="", 
                        `type`="text"),
                    list(
                        `name`="b", 
                        `title`="", 
                        `type`="text"),
                    list(
                        `name`="t", 
                        `title`="t", 
                        `type`="number"),
                    list(
                        `name`="df", 
                        `title`="df", 
                        `type`="integer"),
                    list(
                        `name`="p", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="eqb",
                title="Equivalence Bounds",
                rows=2,
                clearWith=list(
                    "alpha",
                    "low_eqbound",
                    "high_eqbound",
                    "eqbound_type",
                    "pair1",
                    "pair2"),
                columns=list(
                    list(
                        `name`="stat", 
                        `title`="", 
                        `type`="text"),
                    list(
                        `name`="low", 
                        `title`="Low", 
                        `type`="number"),
                    list(
                        `name`="high", 
                        `title`="High", 
                        `type`="number"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="effsize",
                title="Effect Sizes",
                rows=2,
                clearWith=list(
                    "alpha",
                    "smd_type",
                    "pair1",
                    "pair2"),
                columns=list(
                    list(
                        `name`="stat", 
                        `title`="", 
                        `type`="text"),
                    list(
                        `name`="est", 
                        `title`="Estimate", 
                        `type`="number"),
                    list(
                        `name`="cil", 
                        `title`="Lower", 
                        `superTitle`="Confidence interval"),
                    list(
                        `name`="ciu", 
                        `title`="Upper", 
                        `superTitle`="Confidence interval"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="desc",
                title="Descriptives",
                visible="(desc)",
                rows=2,
                clearWith=list(
                    "pair1",
                    "pair2"),
                columns=list(
                    list(
                        `name`="name", 
                        `title`="", 
                        `type`="text"),
                    list(
                        `name`="n", 
                        `title`="N", 
                        `type`="integer"),
                    list(
                        `name`="m", 
                        `title`="Mean", 
                        `type`="number"),
                    list(
                        `name`="med", 
                        `title`="Median", 
                        `type`="number"),
                    list(
                        `name`="sd", 
                        `title`="SD", 
                        `type`="number"),
                    list(
                        `name`="se", 
                        `title`="SE", 
                        `type`="number"))))
            self$add(jmvcore::Image$new(
                options=options,
                name="plots",
                title="Effect Size Plot",
                visible="(plots)",
                renderFun=".plot",
                width=500,
                height=500,
                clearWith=list(
                    "alpha",
                    "low_eqbound",
                    "high_eqbound",
                    "eqbound_type",
                    "smd_type",
                    "pair1",
                    "pair2")))
            self$add(jmvcore::Image$new(
                options=options,
                name="indplot",
                title="Data Plot",
                visible="(indplot)",
                renderFun=".indplot",
                width=400,
                height=375,
                clearWith=list(
                    "alpha",
                    "low_eqbound",
                    "high_eqbound",
                    "eqbound_type",
                    "smd_type",
                    "pair1",
                    "pair2")))
            self$add(jmvcore::Image$new(
                options=options,
                name="diffplot",
                title="Plot Difference",
                visible="(diffplot)",
                renderFun=".diffplot",
                width=400,
                height=375,
                clearWith=list(
                    "alpha",
                    "low_eqbound",
                    "high_eqbound",
                    "eqbound_type",
                    "smd_type",
                    "pair1",
                    "pair2")))}))

dataTOSTpairedBase <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "dataTOSTpairedBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = "TOSTER",
                name = "dataTOSTpaired",
                version = c(1,0,0),
                options = options,
                results = dataTOSTpairedResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = FALSE,
                requiresMissings = FALSE)
        }))

#' TOST Paired Samples T-Test
#'
#' TOST Paired Samples T-Test in jamovi. This function is not meant to be 
#' utilized in R. See t_TOST function.
#'
#' @examples
#' \dontrun{
#' library("TOSTER")
#'
#' dataTOSTpaired(data = randu, pair1 = "x", pair2="y", low_eqbound = -0.3,
#'                high_eqbound = 0.3, alpha = 0.05, desc = TRUE, plots = TRUE)
#'}
#' @section References:
#' Mara, C. A., & Cribbie, R. A. (2012). Paired-Samples Tests of Equivalence. Communications in Statistics - Simulation and Computation, 41(10), 1928-1943. <https://doi.org/10.1080/03610918.2011.626545>, formula page 1932. Note there is a typo in the formula: n-1 should be n (personal communication, 31-08-2016)
#'
#' @param data the data as a data frame
#' @param pair1 A string naming the first part of the pair
#' @param pair2 A string naming the second part of the pair
#' @param hypothesis \code{'EQU'} for equivalence (default), or \code{'MET'}
#'   for minimal effects test, the alternative hypothesis.
#' @param low_eqbound a number (default: 0.5) the lower equivalence bounds
#' @param high_eqbound a number (default: 0.5) the upper equivalence bounds
#' @param eqbound_type \code{'SMD'} (default) or \code{'raw'}; whether the
#'   bounds are specified in standardized mean difference (Cohen's dz) or raw
#'   units respectively
#' @param alpha alpha level (default = 0.05)
#' @param desc \code{TRUE} or \code{FALSE} (default), provide descriptive
#'   statistics
#' @param plots \code{TRUE} or \code{FALSE} (default), provide plots
#' @param low_eqbound_dz deprecated
#' @param high_eqbound_dz deprecated
#' @param indplot \code{TRUE} or \code{FALSE} (default), provide plot of
#'   paired data.
#' @param diffplot \code{TRUE} or \code{FALSE} (default), provide plot of
#'   difference scores.
#' @param smd_type \code{'d'} (default) or \code{'g'}; whether the calculated
#'   effect size is biased (d) or bias-corrected (g).
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$text} \tab \tab \tab \tab \tab a html \cr
#'   \code{results$tost} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$eqb} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$effsize} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$desc} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$plots} \tab \tab \tab \tab \tab an image \cr
#'   \code{results$indplot} \tab \tab \tab \tab \tab an image \cr
#'   \code{results$diffplot} \tab \tab \tab \tab \tab an image \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$tost$asDF}
#'
#' \code{as.data.frame(results$tost)}
#'
#' @export
dataTOSTpaired <- function(
    data,
    pair1,
    pair2,
    hypothesis = "EQU",
    low_eqbound = -0.5,
    high_eqbound = 0.5,
    eqbound_type = "raw",
    alpha = 0.05,
    desc = FALSE,
    plots = FALSE,
    low_eqbound_dz = -999999999,
    high_eqbound_dz = -999999999,
    indplot = FALSE,
    diffplot = FALSE,
    smd_type = "g") {

    if ( ! requireNamespace("jmvcore", quietly=TRUE))
        stop("dataTOSTpaired requires jmvcore to be installed (restart may be required)")

    if ( ! missing(pair1)) pair1 <- jmvcore::resolveQuo(jmvcore::enquo(pair1))
    if ( ! missing(pair2)) pair2 <- jmvcore::resolveQuo(jmvcore::enquo(pair2))
    if (missing(data))
        data <- jmvcore::marshalData(
            parent.frame(),
            `if`( ! missing(pair1), pair1, NULL),
            `if`( ! missing(pair2), pair2, NULL))


    options <- dataTOSTpairedOptions$new(
        pair1 = pair1,
        pair2 = pair2,
        hypothesis = hypothesis,
        low_eqbound = low_eqbound,
        high_eqbound = high_eqbound,
        eqbound_type = eqbound_type,
        alpha = alpha,
        desc = desc,
        plots = plots,
        low_eqbound_dz = low_eqbound_dz,
        high_eqbound_dz = high_eqbound_dz,
        indplot = indplot,
        diffplot = diffplot,
        smd_type = smd_type)

    analysis <- dataTOSTpairedClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}

