% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollDbn.R
\name{rollDbn_v2}
\alias{rollDbn_v2}
\title{Convert a given unrolled Dynamic Bayesian Network (DBN) into a rolled DBN using different rolling methods

Rolls time-varying networks into a single time-invariant network.
This function is compatible with the time-varying networks learnt through
learnDbnStruct3dParDeg1.R::learnDbnStructMo1Layer3dParDeg1_v2().}
\usage{
rollDbn_v2(num.nodes, node.names, num.timepts,
  unrolled.DBN.adj.matrix.list, roll.method, allow.self.loop)
}
\arguments{
\item{num.nodes}{Number of the desired nodes in the rolled DBN}

\item{node.names}{Names of the desired nodes in the rolled DBN}

\item{num.timepts}{Number of time points in the unrolled DBN}

\item{unrolled.DBN.adj.matrix.list}{Given time-varying network adjacency list. Its length =
num.time.trans = (num.timepts - 1). The t^{th} element of the list represents the predicted
network adjacency matrix of the t^{th} time transition. This matrix is of dimension
(num.nodes \ times num.nodes).}

\item{roll.method}{Which rolling method to use from {'any', 'all', or some real number in (0, 1), like - 0.5}.}

\item{allow.self.loop}{Boolean to decide whether to allow self loop or not in the rolled DBN}
}
\value{
rolled.DBN.adj.matrix Return the rolled DBN adjacency matrix. It is a 2D matrix of dimension (num.nodes * num.nodes).
}
\description{
Convert a given unrolled Dynamic Bayesian Network (DBN) into a rolled DBN using different rolling methods

Rolls time-varying networks into a single time-invariant network.
This function is compatible with the time-varying networks learnt through
learnDbnStruct3dParDeg1.R::learnDbnStructMo1Layer3dParDeg1_v2().
}
