% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/tdmMapDesign.r
\name{tdmMapDesApply}
\alias{tdmMapDesApply}
\title{Apply the mapping from \code{des} to \code{opts}.}
\usage{
tdmMapDesApply(des, opts, k, spotConfig, tdm)
}
\arguments{
\item{des}{design points data frame}

\item{opts}{list of options}

\item{k}{apply mapping for the \code{k}-th design point}

\item{spotConfig}{list, we needed here \code{spotConfig$alg.roi} and \code{envT$mapUser}, see \code{\link{tdmMapDesLoad}},
and in addition \code{envT$spotConfig$alg.roi}}

\item{tdm}{list, we need here \code{tdm$map} and \code{tdm$mapUser}}
}
\value{
\code{opts}, the modified list of options
}
\description{
For each variable which appears in .roi (and thus in .des file and design point data frame \code{des}):
   set its counterpart in list \code{opts} to the values of the \code{k}-th row in \code{des}.
   For each variable not appearing: leave its counterpart in \code{opts} at its default value from .apd file.
}
\seealso{
\code{\link{tdmMapDesLoad}}
}

