% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{computeECC}
\alias{computeECC}
\title{A Vector Summary of the Euler Characteristic Curve}

\description{
Vectorizes the Euler characteristic curve
\deqn{
\chi(t)=\sum_{k=0}^d (-1)^k\beta_k(t),} where \eqn{\beta_0,\beta_1,\ldots,\beta_d
} are the Betti curves corresponding to persistence diagrams \eqn{D_0,D_1,\ldots,D_d} of dimeansions \eqn{0,1,\ldots,d} respectively, all computed from the same filtration
}

\usage{
computeECC(D, maxhomDim, scaleSeq)
}

\arguments{
\item{D}{matrix with three columns containing the dimension, birth and death values respectively}

\item{maxhomDim}{maximum homological dimension considered (0 for \eqn{H_0}, 1 for \eqn{H_1}, etc.)}

\item{scaleSeq}{numeric vector of increasing scale values used for vectorization}

}

\value{
A numeric vector whose elements are the average values of the Euler characteristic curve computed between each pair of
consecutive scale points of \code{scaleSeq}=\eqn{\{t_1,t_2,\ldots,t_n\}}:
\deqn{(\frac{1}{\Delta t_1}\int_{t_1}^{t_2}\chi(t)dt,\frac{1}{\Delta t_2}\int_{t_2}^{t_3}\chi(t)dt,\ldots,\frac{1}{\Delta t_{n-1}}\int_{t_{n-1}}^{t_n}\chi(t)dt),}
where \eqn{\Delta t_k=t_{k+1}-t_k}
}

\author{Umar Islambekov}

\references{
1. Richardson, E., & Werman, M. (2014). Efficient classification using the Euler characteristic. Pattern Recognition Letters, 49, 99-106.
}

\examples{
N <- 100
set.seed(123)
# sample N points uniformly from unit circle and add Gaussian noise
X <- TDA::circleUnif(N,r=1) + rnorm(2*N,mean = 0,sd = 0.2)

# compute a persistence diagram using the Rips filtration built on top of X
D <- TDA::ripsDiag(X,maxdimension = 1,maxscale = 2)$diagram

scaleSeq = seq(0,2,length.out=11) # sequence of scale values

# compute ECC
computeECC(D,maxhomDim=1,scaleSeq)
}
