% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_calculations.R
\name{gram_matrix}
\alias{gram_matrix}
\title{Compute the gram matrix for a group of persistence diagrams.}
\usage{
gram_matrix(
  diagrams,
  other_diagrams = NULL,
  dim = 0,
  sigma = 1,
  t = 1,
  num_workers = parallelly::availableCores(omit = 1)
)
}
\arguments{
\item{diagrams}{a list of persistence diagrams, where each diagram is either the output of a TDA/TDAstats calculation like \code{\link[TDA]{ripsDiag}}/\code{\link[TDAstats]{calculate_homology}}, or \code{\link{diagram_to_df}}.}

\item{other_diagrams}{either NULL (default) or another list of persistence diagrams to compute a cross-Gram matrix.}

\item{dim}{the non-negative integer homological dimension in which the distance is to be computed, default 0.}

\item{sigma}{a positive number representing the bandwidth for the Fisher information metric, default 1.}

\item{t}{a positive number representing the scale for the kernel, default 1.}

\item{num_workers}{the number of cores used for parallel computation, default is one less than the number of cores on the machine.}
}
\value{
the numeric (cross) Gram matrix of class 'kernelMatrix'.
}
\description{
Calculate the Gram matrix \eqn{K} for either a single list of persistence diagrams \eqn{(D_1,D_2,\dots,D_n)}, i.e. \eqn{K[i,j] = k_{PF}(D_i,D_j)}, 
or between two lists of persistence diagrams, \eqn{(D_1,D_2,\dots,D_n)} and \eqn{(D'_1,D'_2,\dots,D'_n)}, \eqn{K[i,j] = k_{PF}(D_i,D'_j)}, in parallel.
}
\details{
Gram matrices are used in downstream analyses, like in the `diagram_kkmeans`, `diagram_nearest_cluster`,`diagram_kpca`, 
`predict_diagram_kpca`, `predict_diagram_ksvm` and `independence_test` functions.
}
\examples{

# create two diagrams
D1 <- TDAstats::calculate_homology(TDA::circleUnif(n = 10,r = 1),
                                   dim = 0,threshold = 2)
D2 <- TDAstats::calculate_homology(TDA::circleUnif(n = 10,r = 1),
                                   dim = 0,threshold = 2)
g <- list(D1,D2)

# calculate the Gram matrix in dimension 0 with sigma = 2, t = 2
G <- gram_matrix(diagrams = g,dim = 0,sigma = 2,t = 2,num_workers = 2)

# calculate cross-Gram matrix, which is the same as G
G_cross <- gram_matrix(diagrams = g,other_diagrams = g,dim = 0,sigma = 2,
                       t = 2,num_workers = 2)
}
\author{
Shael Brown - \email{shaelebrown@gmail.com}
}
