% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mapper2D.R
\name{mapper2D}
\alias{mapper2D}
\title{mapper2D function}
\usage{
mapper2D(distance_matrix = dist(data.frame(x = 2 * cos(1:100), y =
  sin(1:100))), filter_values = list(2 * cos(1:100), sin(1:100)),
  num_intervals = c(5, 5), percent_overlap = 50,
  num_bins_when_clustering = 10)
}
\arguments{
\item{distance_matrix}{an n x n matrix of pairwise dissimilarities}

\item{filter_values}{a list of two length n vector of real numbers}

\item{num_intervals}{a vector of two positive integers}

\item{percent_overlap}{a number between 0 and 100 specifying how much adjacent intervals should overlap}

\item{num_bins_when_clustering}{a positive integer that controls whether points in the same level set end up in the same cluster}
}
\value{
An object of class \code{TDAmapper} which is a list of items named \code{adjacency} (adjacency matrix for the edges), \code{num_vertices} (integer number of vertices), \code{level_of_vertex} (vector with \code{level_of_vertex[i]} = index of the level set for vertex i), \code{points_in_vertex} (list with \code{points_in_vertex[[i]]} = vector of indices of points in vertex i), \code{points_in_level} (list with \code{points_in_level[[i]]} = vector of indices of points in level set i, and \code{vertices_in_level} (list with \code{vertices_in_level[[i]]} = vector of indices of vertices in level set i.
}
\description{
This function uses a filter function f: X -> R^2 on a data set X that has n rows (observations) and k columns (variables).
}
\examples{
m2 <- mapper2D(
       distance_matrix = dist(data.frame( x=2*cos(1:100), y=sin(1:100) )),
       filter_values = list( 2*cos(1:100), sin(1:100) ),
       num_intervals = c(5,5),
       percent_overlap = 50,
       num_bins_when_clustering = 10)
\dontrun{
library(igraph)
g2 <- graph.adjacency(m2$adjacency, mode="undirected")
plot(g2, layout = layout.auto(g2) )
}
}
\author{
Paul Pearson, \email{pearsonp@hope.edu}
}
\references{
\url{https://github.com/paultpearson/TDAmapper}
}
\seealso{
\code{\link{mapper1D}}
}
\keyword{mapper2D}

