% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCGAretr_scr.R
\name{get_cancer_types}
\alias{get_cancer_types}
\title{Retrieve a List of Cancer Types as Defined by the TCGA Guidelines}
\usage{
get_cancer_types()
}
\value{
A data.frame with one row per cancer type and two columns
}
\description{
Retrieve information about the different types of cancer that may be 
included in TCGA Studies. Information include Identifier and Cancer Name.
}
\examples{
all_canc <- get_cancer_types()
message(paste("There are", nrow(all_canc), "types on cancer defined at TCGA..."))
head(all_canc)

}
\references{
\itemize{
  \item \url{http://www.biotechworld.it/bioinf/2016/07/11/tcga-data-via-tcgaretriever/}
  \item \url{https://www.data-pulse.com/dev_site/TCGAretriever/}
}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
