% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taf.library.R
\name{taf.library}
\alias{taf.library}
\title{TAF Library}
\usage{
taf.library(package, messages = FALSE, warnings = FALSE)
}
\arguments{
\item{package}{name of a package found in \verb{bootstrap/library}.}

\item{messages}{whether to show messages when package loads.}

\item{warnings}{whether to show warnings when package loads.}
}
\value{
The names of packages currently installed in the TAF library.
}
\description{
Load and attach package from local TAF library.
}
\note{
The purpose of the TAF library is to retain R packages that are not commonly
used (and not on CRAN), to support long-term reproducibility of TAF analyses.
}
\examples{
\dontrun{

# Show packages in TAF library
taf.library()

# Load packages
taf.library(this)
taf.library(that)
}

}
\seealso{
\code{\link{library}} is the underlying base function to load and attach a
package.

\code{\link{taf.bootstrap}} is the procedure to install packages into a local
TAF library, via the \verb{SOFTWARE.bib} metadata file.

\code{\link{detach.packages}} detaches all packages.

\code{\link{TAF-package}} gives an overview of the package.
}
