% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm_kmeanspp.R
\name{kmeanspp}
\alias{kmeanspp}
\title{K-Means++ Clustering}
\usage{
kmeanspp(data, k = 2)
}
\arguments{
\item{data}{an \eqn{(n \times p)} matrix of row-stacked observations.}

\item{k}{the number of clusters (default: 2).}
}
\value{
a named list of S3 class \code{T4cluster} containing 
\describe{
\item{cluster}{a length-\eqn{n} vector of class labels (from \eqn{1:k}).}
\item{algorithm}{name of the algorithm.}
}
}
\description{
\eqn{K}-means++ algorithm is usually used as a fast initialization scheme, though 
it can still be used as a standalone clustering algorithms by first choosing the 
centroids and assign points to the nearest centroids.
}
\examples{
# -------------------------------------------------------------
#            clustering with 'iris' dataset
# -------------------------------------------------------------
## PREPARE
data(iris)
X   = as.matrix(iris[,1:4])
lab = as.integer(as.factor(iris[,5]))

## EMBEDDING WITH PCA
X2d = Rdimtools::do.pca(X, ndim=2)$Y

## CLUSTERING WITH DIFFERENT K VALUES
cl2 = kmeanspp(X, k=2)$cluster
cl3 = kmeanspp(X, k=3)$cluster
cl4 = kmeanspp(X, k=4)$cluster

## VISUALIZATION
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,4), pty="s")
plot(X2d, col=lab, pch=19, main="true label")
plot(X2d, col=cl2, pch=19, main="k-means++: k=2")
plot(X2d, col=cl3, pch=19, main="k-means++: k=3")
plot(X2d, col=cl4, pch=19, main="k-means++: k=4")
par(opar)

}
\references{
\insertRef{arthur_kmeans_2007a}{T4cluster}
}
\concept{algorithm}
