% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features_01_claim_occurrence.R
\name{claim_occurrence}
\alias{claim_occurrence}
\title{Claim Occurrence Times}
\usage{
claim_occurrence(frequency_vector)
}
\arguments{
\item{frequency_vector}{a vector of claim frequencies for all the periods.}
}
\value{
A list of occurrence times such that the \eqn{i}th component of the
list gives the claim occurrence time for all claims that occurred in period
\eqn{i}.
}
\description{
Returns the occurrence times of each of the claims occurring in each of
the periods, assuming the occurrence time of any claim in period \eqn{i}
is uniformly distributed between times \eqn{i - 1} and \eqn{i}.
}
\examples{
n_vector <- c(90, 79, 102, 78, 86, 88, 116, 84, 93, 104)
# occurrence time for all claims originating from period 1
claim_occurrence(n_vector)[[1]]
}
