% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_Results.R
\name{Read_Results}
\alias{Read_Results}
\title{Reads swimming and diving results into a list of strings in preparation for parsing with \code{Swim_Parse}}
\usage{
Read_Results(file, node = NULL)
}
\arguments{
\item{file}{a .pdf or .html file (could be a url) where containing swimming results.  Must be formatted in a "normal" fashion - see vignette}

\item{node}{a CSS node where html results are stored.  Required for html results.}
}
\value{
returns a list of strings containing the information from \code{x}.  Should then be parsed with \code{Swim_Parse}
}
\description{
Outputs list of strings to be processed by \code{Swim_Parse}
}
\examples{
\dontrun{Read_Results("http://www.nyhsswim.com/Results/Boys/2008/NYS/Single.htm", node = "pre")}

}
\seealso{
\code{Read_Results} is meant to be followed by \code{\link{Swim_Parse}}
}
\author{
Greg Pilgrim \email{gpilgrim2670@gmail.com}
}
