% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FederatedApproachStage2.R
\name{summary.FederatedApproachStage2}
\alias{summary.FederatedApproachStage2}
\title{Provides a summary of the surrogacy measures for an object fitted with the 'FederatedApproachStage2()' function.}
\usage{
\method{summary}{FederatedApproachStage2}(object, ...)
}
\arguments{
\item{object}{An object of class 'FederatedApproachStage2' fitted with the 'FederatedApproachStage2()' function.}

\item{...}{...}
}
\value{
The surrogacy measures with their 95\% confidence intervals.
}
\description{
Provides a summary of the surrogacy measures for an object fitted with the 'FederatedApproachStage2()' function.
}
\examples{
\dontrun{
#As an example, the federated data analysis approach can be applied to the Schizo data set
data(Schizo)
Schizo <-  Schizo[order(Schizo$InvestId, Schizo$Id),]
#Create separate datasets for each investigator
Schizo_datasets <- list()

for (invest_id in 1:198) {
Schizo_datasets[[invest_id]] <- Schizo[Schizo$InvestId == invest_id, ]
assign(paste0("Schizo", invest_id), Schizo_datasets[[invest_id]])
}
#Fit the first stage model for each dataset separately
results_stage1 <- list()
invest_ids <- list()
i <- 1
for (invest_id in 1:198) {
  dataset <- Schizo_datasets[[invest_id]]

  skip_to_next <- FALSE
  tryCatch(FederatedApproachStage1(dataset, Surr=CGI, True=PANSS, Treat=Treat, Trial.ID = InvestId,
                                   Min.Treat.Size = 5, Alpha = 0.05),
                                   error = function(e) { skip_to_next <<- TRUE})
  #if the trial does not have the minimum required number, skip to the next
  if(skip_to_next) { next }

  results_stage1[[invest_id]] <- FederatedApproachStage1(dataset, Surr=CGI, True=PANSS, Treat=Treat,
                                                         Trial.ID = InvestId, Min.Treat.Size = 5,
                                                         Alpha = 0.05)
  assign(paste0("stage1_invest", invest_id), results_stage1[[invest_id]])
  invest_ids[[i]] <- invest_id #keep a list of ids with datasets with required number of patients
  i <- i+1
}

invest_ids <- unlist(invest_ids)
invest_ids

#Combine the results of the first stage models
for (invest_id in invest_ids) {
  dataset <- results_stage1[[invest_id]]$Results.Stage.1
  if (invest_id == invest_ids[1]) {
    all_results_stage1<- dataset
 } else {
    all_results_stage1 <- rbind(all_results_stage1,dataset)
  }
}

all_results_stage1 #that combines the results of the first stage models

R.list <- list()
i <- 1
for (invest_id in invest_ids) {
  R <- results_stage1[[invest_id]]$R.i
  R.list[[i]] <- as.matrix(R[1:4,1:4])
  i <- i+1
}

R.list #list that combines all the variance-covariance matrices of the fixed effects

fit <- FederatedApproachStage2(Dataset = all_results_stage1, Intercept.S = Intercept.S,
                               alpha = alpha, Intercept.T = Intercept.T, beta = beta,
                               sigma.SS = sigma.SS, sigma.ST = sigma.ST,
                               sigma.TT = sigma.TT, Obs.per.trial = n,
                               Trial.ID = Trial.ID, R.list = R.list)
summary(fit)
}
}
