% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survbin.R
\name{print.survbin}
\alias{print.survbin}
\title{Prints all the elements of an object fitted with the 'survbin()' function.}
\usage{
\method{print}{survbin}(x, ...)
}
\arguments{
\item{x}{An object of class 'survbin' fitted with the 'survbin()' function.}

\item{...}{...}
}
\value{
The surrogacy measures with their 95\% confidence intervals and the estimated treament effect on the surrogate and true endpoint.
}
\description{
Prints all the elements of an object fitted with the 'survbin()' function.
}
\examples{
\dontrun{
data("colorectal")
fit_bin <- survbin(data = colorectal, true = surv, trueind = SURVIND, surrog = responder,
                   trt = TREAT, center = CENTER, trial = TRIAL, patientid = patientid)
print(fit_bin)
}
}
