% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supercell_prcomp.R
\name{supercell_prcomp}
\alias{supercell_prcomp}
\title{compute PCA for super-cell data (sample-weighted data)}
\usage{
supercell_prcomp(
  X,
  genes.use = NULL,
  genes.exclude = NULL,
  supercell_size = NULL,
  k = 20,
  do.scale = TRUE,
  do.center = TRUE,
  fast.pca = TRUE,
  seed = 12345
)
}
\arguments{
\item{X}{super-cell transposed gene expression matrix (! where rows represent super-cells and cols represent genes)}

\item{genes.use}{genes to use for dimensionality reduction}

\item{genes.exclude}{genes to exclude from dimensionaloty reduction}

\item{supercell_size}{a vector with supercell sizes (ordered the same way as in X)}

\item{k}{number of components to compute}

\item{do.scale}{scale data before PCA}

\item{do.center}{center data before PCA}

\item{fast.pca}{whether to run fast PCA (works for datasets with |super-cells| > 50)}

\item{seed}{a seed to use for \code{set.seed}}
}
\value{
the same object as \link[stats]{prcomp} result
}
\description{
compute PCA for super-cell data (sample-weighted data)
}
