% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prim.R
\name{one.pasting.prog}
\alias{one.pasting.prog}
\title{Perform pasting one time in prognostic case.}
\usage{
one.pasting.prog(d.inside, d.outside, trace.inside.condition, alpha, yvar,
  censorvar, g.str, l.str, type, des.res)
}
\arguments{
\item{d.inside}{the dataset for subjects in consideration after peeling.}

\item{d.outside}{the dataset for subjects outside consideration after peeling.}

\item{trace.inside.condition}{list of signature rules used for d.inside.}

\item{alpha}{a parameter controlling the number of subjects in consideration.}

\item{yvar}{the name for response variable.}

\item{censorvar}{the name for censoring (1: event; 0: censor), default = NULL.}

\item{g.str}{">=".}

\item{l.str}{"<=".}

\item{type}{type of response variable: "c" continuous (default); "s" survival; "b" binary.}

\item{des.res}{the desired response. "larger": prefer larger response (default) "smaller": prefer smaller response.}
}
\value{
a data frame enlisting the signature rules (after pasting) ordered by main effect p-values in each group defined by the rules.
}
\description{
Perform pasting one time in prognostic case.
}
