% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/13-a-unidir-aw-ovlp.r
\name{plot_overlap}
\alias{plot_overlap}
\title{A graphical display for showing relative proportions of pairwise subgroup overlap with two unidirectional arrowed curved lines around a circle}
\usage{
plot_overlap(dat, covari.sel, para = c(0.2, 0.2, 1), font.size = c(1.5, 1.5,
  1), title = NULL)
}
\arguments{
\item{dat}{a data set}

\item{covari.sel}{a vector of indices of covariates}

\item{para}{a vector with three elements specifying the parameters of plot display; the first element is for adjusting the curvature of curves;
the second is for placing the relative position of arrowheads on the lines; the third is for specifying the adjustment of the arrowhead
(there are three possible values, 0, 0.5 and 1)}

\item{font.size}{a vector specifying the size of labels and text; the first element is for the title; the second is for the covariates labels.}

\item{title}{a string specifying the main title.}
}
\description{
This function produces a plot for displaying relative proportions of pairwise subgroup overlap, where the relative proportion is
defined by |intersect(A, B)|/|A|, for any sets A and B and A is the baseline set. The letters represent subgroups defined by the
categories of the selected covariates. Subgroup letters located around a circle have two directional arrowed curved lines to the
other. The arrowed lines have different colours, reflecting the level of overlap proportions. Note that if a subgroup is a baseline
subgroup, then arrows on the curves would be located close to the corresponding letter. Also, the conditions of arrowed curves can be
changed by setting different values on the argument "para".
}
\examples{
# Load the data to be used
data(prca)
dat <- prca

## Overlap plot -------------------------------------------------------------
plot_overlap(dat = dat,
             covari.sel = c(6,5,4,7),
             para = c(0.1, 0.5, 1),
             font.size = c(1.2, 1.2, 0.8),
             title = NULL)
}

