% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sinpoint.R
\name{sinpoint}
\alias{sinpoint}
\title{Gives a table of equally sampled points following a sinusoidal function}
\usage{
sinpoint(x, y, delta, x0 = 0, pos = 1, phase = 1.5, nwave = 1, nint = 50)
}
\arguments{
\item{x}{the x value of the end of the interval}

\item{y}{the y offset (see next parameter)}

\item{delta}{the difference between the min- and maxima in y}

\item{x0}{the x value of the beginning of the interval (0 as default)}

\item{pos}{an integer specifying the kind of vertical offset; should
the sinusoidal function be shifted so that y is the first value (pos = 1, is
the default), the last value (2),the minimum (3) or the maximum (4) of the
function}

\item{phase}{the phase of the function at x0 in multiples of pi (1.5
as default; begins at its lowest)}

\item{nwave}{number of complete sinuses waves (1 as default)}

\item{nint}{number of intervals for the sampling (50 as default)}
}
\value{
a table of points following a sinusoidal function
}
\description{
Gives a table of equally sampled points following a sinusoidal function
}
\examples{
res <- sinpoint(c(4,5), 5, 1, x0 = c(0,1), pos = 3)

plot(res$x, res$y)

multilines(res$i, res$x, res$y, col = c("black" ,"red"), type = "o")

}
