% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tie.lim.R
\name{tie.lim}
\alias{tie.lim}
\title{Discretises lim objects}
\usage{
tie.lim(
  lim = NULL,
  l = NULL,
  r = NULL,
  y = NULL,
  xout = NULL,
  id = 1L,
  to.lower = T,
  warn = T
)
}
\arguments{
\item{lim}{an object convertible into a lim object: either a vector
of length 2 or a list of n left (1st element) and n right (2ndt element)
interval limits, and of n interval IDs. In this case the lim objects have to
be ordered, by ids, dependently to each other, and from left to right. For
each id the lim objects heve to cover the entire interval from the lowest
to the highest value, without overlap.}

\item{l}{a vector of n left interval limits}

\item{r}{a vector of n right interval limits}

\item{y}{a vector of n values to discretise}

\item{xout}{a vector of numeric values specifying where interpolation
is to take place. It will be identical for each id. If NULL the result will
be continuous (points of a continous line).}

\item{id}{a vector of n interval IDs (default is 1 for each interval)}

\item{to.lower}{whether to take the left (lower) or right point for
interpolation at adjacent points}

\item{warn}{whether to warn if the sampling interval is prone to
miss the smallest intervals.}
}
\description{
Discretises continuous lim objects by constant interpolation
}
\examples{
l  <- matrix(1:30, ncol = 3, byrow = FALSE)
r  <- matrix(2:31, ncol = 3, byrow = FALSE)
id <- matrix(rep(c("C1", "C2", "C3"),10), ncol = 3, byrow = TRUE)
y  <- matrix(rep(1:10,3), ncol = 3, byrow = FALSE)
xout <- seq(-2,32,0.5)

res  <- tie.lim(l = l, r = r,  y = y, xout = xout, id = id)

cont <- tie.lim(l = l, r = r,  y = y, id = id)

plot(res$x, res$y, pch = 19, col = "red")

lines(cont$x[,1], cont$y[,1])
lines(cont$x[,2], cont$y[,2])
lines(cont$x[,3], cont$y[,3])

}
\seealso{
\code{\link{as.lim}}
}
