% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_walk.R
\name{random_walk}
\alias{random_walk}
\title{continuous time random walk}
\usage{
random_walk(t, sigma = 1, mu = 0, y0 = 0)
}
\arguments{
\item{t}{numeric vector with strictly increasing elements, can be heterodistant. Times at which the random walk is evaluated}

\item{sigma}{positive scalar, variance parameter}

\item{mu}{scalar, directionality parameter}

\item{y0}{scalar, starting value (value of the random walk at the first entry of \code{t})}
}
\value{
A list with elements \code{t} and \code{y}. \code{t} is a duplicate of the input parameter and is the times at which the random walk is evaluated. \code{y} are the values of the random walk at said times. Output list is of S3 class \code{timelist} (inherits from \code{list}) and can thus be plotted directly using \code{plot}, see \code{?admtools::plot.timelist}
}
\description{
Simulates a (continuous time) random walk as a Brownian drift
}
\examples{

library("admtools") # required for plotting of results
t = seq(0, 1, by = 0.01)
l = random_walk(t, sigma = 3) # high variability, no direction
plot(l, type = "l")
l2 = random_walk(t, mu = 1) # low variabliity, increasing trend
lines(l2$t, l2$y, col = "red")


}
