% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection_functions.R
\name{summarize.posteriors.on.simulated.dataset}
\alias{summarize.posteriors.on.simulated.dataset}
\title{Calculate classification performance on simulated data}
\usage{
summarize.posteriors.on.simulated.dataset(data, rej.cut = 0.05, n.muts)
}
\arguments{
\item{data}{Dataset as generated by \code{\link{sim.data.from.priors.for.mod.selection}}
or \code{\link{sim.data.for.mod.selection}}}

\item{rej.cut}{Rejection cutoff point specifies at what posterior probability is a model rejected. Default is 0.05.}

\item{n.muts}{Vector of number of mutations to simulate}
}
\value{
Dataframe with false rejection rate, correct and unique classification rate, and
 mean posterior probability for each parameter combination in the data.
}
\description{
Calculate classification performance on simulated data
}
\details{
If a model has posterior probability < \code{rej.cut}, it is rejected. If a model has posterior
probability \eqn{\ge}  1-\code{rej.cut}, it is considered uniquely accepted.
}

