% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_wilcox.R
\name{steiner_comparison_wilcox}
\alias{steiner_comparison_wilcox}
\title{Perform wilcox test}
\usage{
steiner_comparison_wilcox(type, method, data)
}
\arguments{
\item{type}{a character vector, which indicates type of algorithms to analyse. Can be
"EXA", "SP", "KB", "RSP", "SPM" or "ASP".}

\item{method}{a character scalar; specifies a calculated parameter based on which comparison is performed. Can be 
"runtime" (for time of execution), "log10runtime" "edge" (for number of edges in resultant steiner tree),
"log10edge", "ter_freq" (for terminal frequency in resultant steiner tree) or 
"edge_dens" (for edge density in resultant steiner tree).}

\item{data}{should have structure as output of steiner_simulation function.}
}
\value{
Object of class "pairwise.htest"
}
\description{
Perform pairwise Wilcoxon rank sum tests
}
\details{
"holm" method for adjusting p-values is used.
}
\examples{
g <- graph("Cubical")

data <- steiner_simulation(type = c("SP", "KB", "SPM"),
                           graph = g,
                           ter_list = generate_st_samples(graph = g,
                                                          ter_number = c(2, 3),
                                                          prob = c(0.1, 0.2)))

steiner_comparison_wilcox(type = c("SP", "KB"),
                          method = "ter_freq",
                          data = data)

}
\references{
1. Afshin Sadeghi and Holger Froehlich, "Steiner tree methods for optimal sub-network
               identification: an empirical study", BMC Bioinformatics 2013 14:144
}
\seealso{
\code{\link{generate_st_samples}}, \code{\link{steiner_simulation}},
         \code{\link{steinertree}}, \code{pairwise.wilcox.test}
}
