// Generated by rstantools.  Do not edit by hand.

/*
    StanMoMo is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    StanMoMo is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with StanMoMo.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_M6model_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 23, column 2 to column 38)",
                                                      " (in 'string', line 24, column 2 to column 10)",
                                                      " (in 'string', line 25, column 2 to column 10)",
                                                      " (in 'string', line 26, column 2 to column 33)",
                                                      " (in 'string', line 27, column 2 to column 14)",
                                                      " (in 'string', line 28, column 2 to column 15)",
                                                      " (in 'string', line 29, column 2 to column 29)",
                                                      " (in 'string', line 30, column 2 to column 11)",
                                                      " (in 'string', line 31, column 2 to column 12)",
                                                      " (in 'string', line 32, column 2 to column 17)",
                                                      " (in 'string', line 35, column 2 to column 14)",
                                                      " (in 'string', line 36, column 2 to column 33)",
                                                      " (in 'string', line 37, column 18 to column 37)",
                                                      " (in 'string', line 37, column 2 to column 37)",
                                                      " (in 'string', line 38, column 2 to column 9)",
                                                      " (in 'string', line 39, column 2 to column 16)",
                                                      " (in 'string', line 40, column 2 to column 9)",
                                                      " (in 'string', line 74, column 2 to column 19)",
                                                      " (in 'string', line 75, column 2 to column 20)",
                                                      " (in 'string', line 76, column 2 to column 19)",
                                                      " (in 'string', line 77, column 2 to column 20)",
                                                      " (in 'string', line 78, column 2 to column 18)",
                                                      " (in 'string', line 79, column 2 to column 22)",
                                                      " (in 'string', line 80, column 2 to column 26)",
                                                      " (in 'string', line 81, column 2 to column 14)",
                                                      " (in 'string', line 82, column 2 to column 14)",
                                                      " (in 'string', line 83, column 2 to column 14)",
                                                      " (in 'string', line 85, column 2 to column 46)",
                                                      " (in 'string', line 86, column 20 to column 72)",
                                                      " (in 'string', line 86, column 2 to column 72)",
                                                      " (in 'string', line 87, column 2 to column 110)",
                                                      " (in 'string', line 89, column 20 to column 140)",
                                                      " (in 'string', line 89, column 2 to column 140)",
                                                      " (in 'string', line 91, column 2 to column 55)",
                                                      " (in 'string', line 92, column 2 to column 55)",
                                                      " (in 'string', line 93, column 20 to column 79)",
                                                      " (in 'string', line 93, column 2 to column 79)",
                                                      " (in 'string', line 94, column 2 to column 23)",
                                                      " (in 'string', line 116, column 9 to column 92)",
                                                      " (in 'string', line 117, column 4 to column 13)",
                                                      " (in 'string', line 115, column 13 to line 118, column 11)",
                                                      " (in 'string', line 113, column 9 to column 24)",
                                                      " (in 'string', line 114, column 4 to column 13)",
                                                      " (in 'string', line 112, column 68 to line 115, column 7)",
                                                      " (in 'string', line 112, column 6 to line 118, column 11)",
                                                      " (in 'string', line 111, column 38 to line 119, column 3)",
                                                      " (in 'string', line 111, column 23 to line 119, column 3)",
                                                      " (in 'string', line 111, column 5 to line 119, column 3)",
                                                      " (in 'string', line 121, column 5 to column 120)",
                                                      " (in 'string', line 122, column 5 to column 15)",
                                                      " (in 'string', line 120, column 32 to line 123, column 1)",
                                                      " (in 'string', line 120, column 17 to line 123, column 1)",
                                                      " (in 'string', line 120, column 2 to line 123, column 1)",
                                                      " (in 'string', line 125, column 5 to column 126)",
                                                      " (in 'string', line 126, column 5 to column 15)",
                                                      " (in 'string', line 124, column 34 to line 127, column 1)",
                                                      " (in 'string', line 124, column 19 to line 127, column 1)",
                                                      " (in 'string', line 124, column 1 to line 127, column 1)",
                                                      " (in 'string', line 110, column 22 to line 128, column 3)",
                                                      " (in 'string', line 110, column 7 to line 128, column 3)",
                                                      " (in 'string', line 97, column 4 to column 63)",
                                                      " (in 'string', line 98, column 4 to column 13)",
                                                      " (in 'string', line 96, column 37 to line 99, column 3)",
                                                      " (in 'string', line 96, column 22 to line 99, column 3)",
                                                      " (in 'string', line 96, column 4 to line 99, column 3)",
                                                      " (in 'string', line 100, column 2 to column 19)",
                                                      " (in 'string', line 102, column 4 to column 108)",
                                                      " (in 'string', line 103, column 5 to column 15)",
                                                      " (in 'string', line 101, column 32 to line 104, column 1)",
                                                      " (in 'string', line 101, column 17 to line 104, column 1)",
                                                      " (in 'string', line 101, column 2 to line 104, column 1)",
                                                      " (in 'string', line 106, column 4 to column 113)",
                                                      " (in 'string', line 107, column 5 to column 15)",
                                                      " (in 'string', line 105, column 34 to line 108, column 1)",
                                                      " (in 'string', line 105, column 19 to line 108, column 1)",
                                                      " (in 'string', line 105, column 1 to line 108, column 1)",
                                                      " (in 'string', line 95, column 16 to line 109, column 3)",
                                                      " (in 'string', line 95, column 2 to line 128, column 3)",
                                                      " (in 'string', line 43, column 9 to column 14)",
                                                      " (in 'string', line 43, column 2 to column 19)",
                                                      " (in 'string', line 44, column 2 to column 14)",
                                                      " (in 'string', line 46, column 4 to column 71)",
                                                      " (in 'string', line 47, column 4 to column 13)",
                                                      " (in 'string', line 45, column 32 to line 48, column 3)",
                                                      " (in 'string', line 45, column 17 to line 48, column 3)",
                                                      " (in 'string', line 45, column 2 to line 48, column 3)",
                                                      " (in 'string', line 49, column 2 to column 42)",
                                                      " (in 'string', line 50, column 2 to column 43)",
                                                      " (in 'string', line 51, column 2 to column 59)",
                                                      " (in 'string', line 52, column 2 to line 53, column 36)",
                                                      " (in 'string', line 55, column 1 to column 40)",
                                                      " (in 'string', line 56, column 0 to column 47)",
                                                      " (in 'string', line 57, column 0 to column 78)",
                                                      " (in 'string', line 63, column 4 to column 48)",
                                                      " (in 'string', line 62, column 7 to line 64, column 3)",
                                                      " (in 'string', line 60, column 4 to column 38)",
                                                      " (in 'string', line 59, column 18 to line 61, column 3)",
                                                      " (in 'string', line 59, column 3 to line 64, column 3)",
                                                      " (in 'string', line 65, column 2 to column 41)",
                                                      " (in 'string', line 66, column 2 to column 39)",
                                                      " (in 'string', line 67, column 2 to column 39)",
                                                      " (in 'string', line 68, column 2 to column 35)",
                                                      " (in 'string', line 69, column 2 to column 40)",
                                                      " (in 'string', line 70, column 2 to column 41)",
                                                      " (in 'string', line 71, column 18 to column 72)",
                                                      " (in 'string', line 71, column 2 to column 72)",
                                                      " (in 'string', line 3, column 2 to column 19)",
                                                      " (in 'string', line 4, column 2 to column 19)",
                                                      " (in 'string', line 5, column 8 to column 11)",
                                                      " (in 'string', line 5, column 2 to column 19)",
                                                      " (in 'string', line 6, column 9 to column 13)",
                                                      " (in 'string', line 6, column 2 to column 17)",
                                                      " (in 'string', line 7, column 9 to column 10)",
                                                      " (in 'string', line 7, column 2 to column 16)",
                                                      " (in 'string', line 8, column 2 to column 22)",
                                                      " (in 'string', line 9, column 3 to column 23)",
                                                      " (in 'string', line 10, column 8 to column 14)",
                                                      " (in 'string', line 10, column 2 to column 25)",
                                                      " (in 'string', line 11, column 9 to column 16)",
                                                      " (in 'string', line 11, column 2 to column 23)",
                                                      " (in 'string', line 12, column 2 to column 30)",
                                                      " (in 'string', line 15, column 9 to column 14)",
                                                      " (in 'string', line 15, column 2 to column 38)",
                                                      " (in 'string', line 16, column 9 to column 17)",
                                                      " (in 'string', line 16, column 2 to column 39)",
                                                      " (in 'string', line 17, column 2 to column 19)",
                                                      " (in 'string', line 18, column 2 to column 19)",
                                                      " (in 'string', line 19, column 3 to column 11)",
                                                      " (in 'string', line 20, column 2 to column 11)",
                                                      " (in 'string', line 23, column 8 to column 18)",
                                                      " (in 'string', line 27, column 9 to column 10)",
                                                      " (in 'string', line 28, column 9 to column 10)",
                                                      " (in 'string', line 32, column 9 to column 12)",
                                                      " (in 'string', line 35, column 9 to column 10)",
                                                      " (in 'string', line 74, column 9 to column 13)",
                                                      " (in 'string', line 75, column 9 to column 13)",
                                                      " (in 'string', line 76, column 9 to column 13)",
                                                      " (in 'string', line 77, column 9 to column 15)",
                                                      " (in 'string', line 78, column 9 to column 10)",
                                                      " (in 'string', line 79, column 9 to column 12)",
                                                      " (in 'string', line 80, column 9 to column 15)"};
#include <stan_meta_header.hpp>
class model_M6model final : public model_base_crtp<model_M6model> {
private:
  int J;
  int T;
  std::vector<int> d;
  Eigen::Matrix<double, -1, 1> e;
  Eigen::Matrix<double, -1, 1> age;
  int Tfor;
  int Tval;
  std::vector<int> dval;
  Eigen::Matrix<double, -1, 1> eval;
  int family;
  Eigen::Matrix<double, -1, 1> input_offset;
  Eigen::Matrix<double, -1, 1> offset2;
  int C;
  int L;
  int aux_1dim__;
  int gs_1dim__;
  int gf_1dim__;
  int log_lik_1dim__;
  int log_lik2_1dim__;
 
public:
  ~model_M6model() { }
  
  inline std::string model_name() const final { return "model_M6model"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_M6model(stan::io::var_context& context__,
                unsigned int random_seed__ = 0,
                std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_M6model_namespace::model_M6model";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 107;
      context__.validate_dims("data initialization","J","int",
          context__.to_vec());
      J = std::numeric_limits<int>::min();
      
      current_statement__ = 107;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 107;
      current_statement__ = 107;
      check_greater_or_equal(function__, "J", J, 1);
      current_statement__ = 108;
      context__.validate_dims("data initialization","T","int",
          context__.to_vec());
      T = std::numeric_limits<int>::min();
      
      current_statement__ = 108;
      T = context__.vals_i("T")[(1 - 1)];
      current_statement__ = 108;
      current_statement__ = 108;
      check_greater_or_equal(function__, "T", T, 1);
      current_statement__ = 109;
      validate_non_negative_index("d", "J * T", (J * T));
      current_statement__ = 110;
      context__.validate_dims("data initialization","d","int",
          context__.to_vec((J * T)));
      d = std::vector<int>((J * T), std::numeric_limits<int>::min());
      
      current_statement__ = 110;
      assign(d, nil_index_list(), context__.vals_i("d"),
        "assigning variable d");
      current_statement__ = 111;
      validate_non_negative_index("e", "J * T", (J * T));
      current_statement__ = 112;
      context__.validate_dims("data initialization","e","double",
          context__.to_vec((J * T)));
      e = Eigen::Matrix<double, -1, 1>((J * T));
      stan::math::fill(e, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> e_flat__;
        current_statement__ = 112;
        assign(e_flat__, nil_index_list(), context__.vals_r("e"),
          "assigning variable e_flat__");
        current_statement__ = 112;
        pos__ = 1;
        current_statement__ = 112;
        for (int sym1__ = 1; sym1__ <= (J * T); ++sym1__) {
          current_statement__ = 112;
          assign(e, cons_list(index_uni(sym1__), nil_index_list()),
            e_flat__[(pos__ - 1)], "assigning variable e");
          current_statement__ = 112;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 113;
      validate_non_negative_index("age", "J", J);
      current_statement__ = 114;
      context__.validate_dims("data initialization","age","double",
          context__.to_vec(J));
      age = Eigen::Matrix<double, -1, 1>(J);
      stan::math::fill(age, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> age_flat__;
        current_statement__ = 114;
        assign(age_flat__, nil_index_list(), context__.vals_r("age"),
          "assigning variable age_flat__");
        current_statement__ = 114;
        pos__ = 1;
        current_statement__ = 114;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 114;
          assign(age, cons_list(index_uni(sym1__), nil_index_list()),
            age_flat__[(pos__ - 1)], "assigning variable age");
          current_statement__ = 114;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 115;
      context__.validate_dims("data initialization","Tfor","int",
          context__.to_vec());
      Tfor = std::numeric_limits<int>::min();
      
      current_statement__ = 115;
      Tfor = context__.vals_i("Tfor")[(1 - 1)];
      current_statement__ = 115;
      current_statement__ = 115;
      check_greater_or_equal(function__, "Tfor", Tfor, 1);
      current_statement__ = 116;
      context__.validate_dims("data initialization","Tval","int",
          context__.to_vec());
      Tval = std::numeric_limits<int>::min();
      
      current_statement__ = 116;
      Tval = context__.vals_i("Tval")[(1 - 1)];
      current_statement__ = 116;
      current_statement__ = 116;
      check_greater_or_equal(function__, "Tval", Tval, 0);
      current_statement__ = 117;
      validate_non_negative_index("dval", "J * Tval", (J * Tval));
      current_statement__ = 118;
      context__.validate_dims("data initialization","dval","int",
          context__.to_vec((J * Tval)));
      dval = std::vector<int>((J * Tval), std::numeric_limits<int>::min());
      
      current_statement__ = 118;
      assign(dval, nil_index_list(), context__.vals_i("dval"),
        "assigning variable dval");
      current_statement__ = 119;
      validate_non_negative_index("eval", "J * Tval", (J * Tval));
      current_statement__ = 120;
      context__.validate_dims("data initialization","eval","double",
          context__.to_vec((J * Tval)));
      eval = Eigen::Matrix<double, -1, 1>((J * Tval));
      stan::math::fill(eval, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> eval_flat__;
        current_statement__ = 120;
        assign(eval_flat__, nil_index_list(), context__.vals_r("eval"),
          "assigning variable eval_flat__");
        current_statement__ = 120;
        pos__ = 1;
        current_statement__ = 120;
        for (int sym1__ = 1; sym1__ <= (J * Tval); ++sym1__) {
          current_statement__ = 120;
          assign(eval, cons_list(index_uni(sym1__), nil_index_list()),
            eval_flat__[(pos__ - 1)], "assigning variable eval");
          current_statement__ = 120;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 121;
      context__.validate_dims("data initialization","family","int",
          context__.to_vec());
      family = std::numeric_limits<int>::min();
      
      current_statement__ = 121;
      family = context__.vals_i("family")[(1 - 1)];
      current_statement__ = 121;
      current_statement__ = 121;
      check_greater_or_equal(function__, "family", family, 0);
      current_statement__ = 121;
      current_statement__ = 121;
      check_less_or_equal(function__, "family", family, 1);
      current_statement__ = 122;
      validate_non_negative_index("input_offset", "J * T", (J * T));
      current_statement__ = 123;
      input_offset = Eigen::Matrix<double, -1, 1>((J * T));
      stan::math::fill(input_offset, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 123;
      assign(input_offset, nil_index_list(), stan::math::log(e),
        "assigning variable input_offset");
      current_statement__ = 124;
      validate_non_negative_index("offset2", "J * Tval", (J * Tval));
      current_statement__ = 125;
      offset2 = Eigen::Matrix<double, -1, 1>((J * Tval));
      stan::math::fill(offset2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 125;
      assign(offset2, nil_index_list(), stan::math::log(eval),
        "assigning variable offset2");
      current_statement__ = 126;
      C = std::numeric_limits<int>::min();
      
      current_statement__ = 127;
      L = std::numeric_limits<int>::min();
      
      current_statement__ = 128;
      C = ((J + T) - 1);
      current_statement__ = 129;
      L = (J * Tfor);
      current_statement__ = 126;
      current_statement__ = 126;
      check_greater_or_equal(function__, "C", C, 1);
      current_statement__ = 127;
      current_statement__ = 127;
      check_greater_or_equal(function__, "L", L, 1);
      current_statement__ = 130;
      aux_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 130;
      aux_1dim__ = logical_gt(family, 0);
      current_statement__ = 130;
      validate_non_negative_index("aux", "family > 0", aux_1dim__);
      current_statement__ = 131;
      validate_non_negative_index("k", "T", T);
      current_statement__ = 132;
      validate_non_negative_index("k2", "T", T);
      current_statement__ = 133;
      gs_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 133;
      gs_1dim__ = (C - 2);
      current_statement__ = 133;
      validate_non_negative_index("gs", "C - 2", gs_1dim__);
      current_statement__ = 134;
      validate_non_negative_index("g", "C", C);
      current_statement__ = 135;
      validate_non_negative_index("k_p", "Tfor", Tfor);
      current_statement__ = 136;
      validate_non_negative_index("k2_p", "Tfor", Tfor);
      current_statement__ = 137;
      validate_non_negative_index("g_p", "Tfor", Tfor);
      current_statement__ = 138;
      gf_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 138;
      gf_1dim__ = (C + Tfor);
      current_statement__ = 138;
      validate_non_negative_index("gf", "C + Tfor", gf_1dim__);
      current_statement__ = 139;
      validate_non_negative_index("mufor", "L", L);
      current_statement__ = 140;
      log_lik_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 140;
      log_lik_1dim__ = (J * T);
      current_statement__ = 140;
      validate_non_negative_index("log_lik", "J * T", log_lik_1dim__);
      current_statement__ = 141;
      log_lik2_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 141;
      log_lik2_1dim__ = (J * Tval);
      current_statement__ = 141;
      validate_non_negative_index("log_lik2", "J * Tval", log_lik2_1dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += aux_1dim__;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 3;
      num_params_r__ += T;
      num_params_r__ += T;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += gs_1dim__;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_M6model_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<local_scalar_t__> aux;
      aux = std::vector<local_scalar_t__>(aux_1dim__, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= aux_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(aux, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable aux");}
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= aux_1dim__; ++sym1__) {
        current_statement__ = 1;
        if (jacobian__) {
          current_statement__ = 1;
          assign(aux, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(aux[(sym1__ - 1)], 0, lp__),
            "assigning variable aux");
        } else {
          current_statement__ = 1;
          assign(aux, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(aux[(sym1__ - 1)], 0),
            "assigning variable aux");
        }}
      local_scalar_t__ c1;
      c1 = DUMMY_VAR__;
      
      current_statement__ = 2;
      c1 = in__.scalar();
      local_scalar_t__ c2;
      c2 = DUMMY_VAR__;
      
      current_statement__ = 3;
      c2 = in__.scalar();
      std::vector<local_scalar_t__> sigma;
      sigma = std::vector<local_scalar_t__>(3, DUMMY_VAR__);
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
        current_statement__ = 4;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
        current_statement__ = 4;
        if (jacobian__) {
          current_statement__ = 4;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma[(sym1__ - 1)], 0, lp__),
            "assigning variable sigma");
        } else {
          current_statement__ = 4;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma[(sym1__ - 1)], 0),
            "assigning variable sigma");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> k;
      k = Eigen::Matrix<local_scalar_t__, -1, 1>(T);
      stan::math::fill(k, DUMMY_VAR__);
      
      current_statement__ = 5;
      k = in__.vector(T);
      Eigen::Matrix<local_scalar_t__, -1, 1> k2;
      k2 = Eigen::Matrix<local_scalar_t__, -1, 1>(T);
      stan::math::fill(k2, DUMMY_VAR__);
      
      current_statement__ = 6;
      k2 = in__.vector(T);
      local_scalar_t__ rho;
      rho = DUMMY_VAR__;
      
      current_statement__ = 7;
      rho = in__.scalar();
      current_statement__ = 7;
      if (jacobian__) {
        current_statement__ = 7;
        rho = stan::math::lub_constrain(rho, -1, 1, lp__);
      } else {
        current_statement__ = 7;
        rho = stan::math::lub_constrain(rho, -1, 1);
      }
      local_scalar_t__ psi;
      psi = DUMMY_VAR__;
      
      current_statement__ = 8;
      psi = in__.scalar();
      local_scalar_t__ psi2;
      psi2 = DUMMY_VAR__;
      
      current_statement__ = 9;
      psi2 = in__.scalar();
      Eigen::Matrix<local_scalar_t__, -1, 1> gs;
      gs = Eigen::Matrix<local_scalar_t__, -1, 1>(gs_1dim__);
      stan::math::fill(gs, DUMMY_VAR__);
      
      current_statement__ = 10;
      gs = in__.vector(gs_1dim__);
      Eigen::Matrix<local_scalar_t__, -1, 1> g;
      g = Eigen::Matrix<local_scalar_t__, -1, 1>(C);
      stan::math::fill(g, DUMMY_VAR__);
      
      local_scalar_t__ phi;
      phi = DUMMY_VAR__;
      
      current_statement__ = 12;
      phi = stan::math::negative_infinity();
      current_statement__ = 14;
      if (logical_gt(family, 0)) {
        current_statement__ = 13;
        phi = inv(aux[(1 - 1)]);
      } 
      current_statement__ = 15;
      assign(g, cons_list(index_uni(1), nil_index_list()), 0,
        "assigning variable g");
      current_statement__ = 16;
      assign(g, cons_list(index_min_max(2, (C - 1)), nil_index_list()), gs,
        "assigning variable g");
      current_statement__ = 17;
      assign(g, cons_list(index_uni(C), nil_index_list()), 0,
        "assigning variable g");
      {
        current_statement__ = 79;
        validate_non_negative_index("mu", "J * T", (J * T));
        Eigen::Matrix<local_scalar_t__, -1, 1> mu;
        mu = Eigen::Matrix<local_scalar_t__, -1, 1>((J * T));
        stan::math::fill(mu, DUMMY_VAR__);
        
        int pos;
        pos = std::numeric_limits<int>::min();
        
        current_statement__ = 81;
        pos = 1;
        current_statement__ = 86;
        for (int t = 1; t <= T; ++t) {
          current_statement__ = 85;
          for (int x = 1; x <= J; ++x) {
            current_statement__ = 82;
            assign(mu, cons_list(index_uni(pos), nil_index_list()),
              (((input_offset[(pos - 1)] + k[(t - 1)]) +
                 ((age[(x - 1)] - mean(age)) * k2[(t - 1)])) +
                g[(((t - x) + J) - 1)]), "assigning variable mu");
            current_statement__ = 83;
            pos = (pos + 1);}}
        current_statement__ = 87;
        lp_accum__.add(
          normal_lpdf<false>(k[(1 - 1)], c1, stan::math::sqrt(10)));
        current_statement__ = 88;
        lp_accum__.add(
          normal_lpdf<false>(k2[(1 - 1)], c2, stan::math::sqrt(10)));
        current_statement__ = 89;
        lp_accum__.add(
          normal_lpdf<false>(
            rvalue(k, cons_list(index_min_max(2, T), nil_index_list()), "k"),
            add(c1,
              rvalue(k,
                cons_list(index_min_max(1, (T - 1)), nil_index_list()), "k")),
            sigma[(1 - 1)]));
        current_statement__ = 90;
        lp_accum__.add(
          normal_lpdf<false>(
            rvalue(k2, cons_list(index_min_max(2, T), nil_index_list()),
              "k2"),
            add(
              add(c2,
                rvalue(k2,
                  cons_list(index_min_max(1, (T - 1)), nil_index_list()),
                  "k2")),
              divide(
                multiply((rho * sigma[(2 - 1)]),
                  subtract(
                    subtract(
                      rvalue(k,
                        cons_list(index_min_max(2, T), nil_index_list()),
                        "k"), c1),
                    rvalue(k,
                      cons_list(index_min_max(1, (T - 1)), nil_index_list()),
                      "k"))), sigma[(1 - 1)])),
            (sigma[(2 - 1)] * stan::math::sqrt((1 - square(rho))))));
        current_statement__ = 91;
        lp_accum__.add(normal_lpdf<false>(gs[(1 - 1)], 0, sigma[(3 - 1)]));
        current_statement__ = 92;
        lp_accum__.add(
          normal_lpdf<false>(gs[(2 - 1)], (psi * gs[(1 - 1)]),
            sigma[(3 - 1)]));
        current_statement__ = 93;
        lp_accum__.add(
          normal_lpdf<false>(
            rvalue(gs,
              cons_list(index_min_max(3, (C - 2)), nil_index_list()), "gs"),
            add(
              multiply(psi,
                rvalue(gs,
                  cons_list(index_min_max(2, (C - 3)), nil_index_list()),
                  "gs")),
              multiply(psi2,
                rvalue(gs,
                  cons_list(index_min_max(1, (C - 4)), nil_index_list()),
                  "gs"))), sigma[(3 - 1)]));
        current_statement__ = 98;
        if (logical_eq(family, 0)) {
          current_statement__ = 96;
          lp_accum__.add(poisson_log_lpmf<false>(d, mu));
        } else {
          current_statement__ = 94;
          lp_accum__.add(neg_binomial_2_log_lpmf<false>(d, mu, phi));
        }
        current_statement__ = 99;
        lp_accum__.add(exponential_lpdf<false>(sigma, 0.1));
        current_statement__ = 100;
        lp_accum__.add(normal_lpdf<false>(c1, 0, stan::math::sqrt(10)));
        current_statement__ = 101;
        lp_accum__.add(normal_lpdf<false>(c2, 0, stan::math::sqrt(10)));
        current_statement__ = 102;
        lp_accum__.add(uniform_lpdf<false>(rho, -1, 1));
        current_statement__ = 103;
        lp_accum__.add(normal_lpdf<false>(psi, 0, stan::math::sqrt(10)));
        current_statement__ = 104;
        lp_accum__.add(normal_lpdf<false>(psi2, 0, stan::math::sqrt(10)));
        current_statement__ = 106;
        if (logical_gt(family, 0)) {
          current_statement__ = 105;
          lp_accum__.add(
            (normal_lpdf<false>(aux, 0, 1) - normal_lcdf(0, 0, 1)));
        } 
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_M6model_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<double> aux;
      aux = std::vector<double>(aux_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= aux_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(aux, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable aux");}
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= aux_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(aux, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(aux[(sym1__ - 1)], 0),
          "assigning variable aux");}
      double c1;
      c1 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      c1 = in__.scalar();
      double c2;
      c2 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      c2 = in__.scalar();
      std::vector<double> sigma;
      sigma = std::vector<double>(3, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
        current_statement__ = 4;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
        current_statement__ = 4;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigma[(sym1__ - 1)], 0),
          "assigning variable sigma");}
      Eigen::Matrix<double, -1, 1> k;
      k = Eigen::Matrix<double, -1, 1>(T);
      stan::math::fill(k, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      k = in__.vector(T);
      Eigen::Matrix<double, -1, 1> k2;
      k2 = Eigen::Matrix<double, -1, 1>(T);
      stan::math::fill(k2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      k2 = in__.vector(T);
      double rho;
      rho = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      rho = in__.scalar();
      current_statement__ = 7;
      rho = stan::math::lub_constrain(rho, -1, 1);
      double psi;
      psi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      psi = in__.scalar();
      double psi2;
      psi2 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      psi2 = in__.scalar();
      Eigen::Matrix<double, -1, 1> gs;
      gs = Eigen::Matrix<double, -1, 1>(gs_1dim__);
      stan::math::fill(gs, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 10;
      gs = in__.vector(gs_1dim__);
      Eigen::Matrix<double, -1, 1> g;
      g = Eigen::Matrix<double, -1, 1>(C);
      stan::math::fill(g, std::numeric_limits<double>::quiet_NaN());
      
      double phi;
      phi = std::numeric_limits<double>::quiet_NaN();
      
      for (int sym1__ = 1; sym1__ <= aux_1dim__; ++sym1__) {
        vars__.emplace_back(aux[(sym1__ - 1)]);}
      vars__.emplace_back(c1);
      vars__.emplace_back(c2);
      for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
        vars__.emplace_back(sigma[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        vars__.emplace_back(k[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        vars__.emplace_back(k2[(sym1__ - 1)]);}
      vars__.emplace_back(rho);
      vars__.emplace_back(psi);
      vars__.emplace_back(psi2);
      for (int sym1__ = 1; sym1__ <= gs_1dim__; ++sym1__) {
        vars__.emplace_back(gs[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 12;
      phi = stan::math::negative_infinity();
      current_statement__ = 14;
      if (logical_gt(family, 0)) {
        current_statement__ = 13;
        phi = inv(aux[(1 - 1)]);
      } 
      current_statement__ = 15;
      assign(g, cons_list(index_uni(1), nil_index_list()), 0,
        "assigning variable g");
      current_statement__ = 16;
      assign(g, cons_list(index_min_max(2, (C - 1)), nil_index_list()), gs,
        "assigning variable g");
      current_statement__ = 17;
      assign(g, cons_list(index_uni(C), nil_index_list()), 0,
        "assigning variable g");
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
          vars__.emplace_back(g[(sym1__ - 1)]);}
        vars__.emplace_back(phi);
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, 1> k_p;
      k_p = Eigen::Matrix<double, -1, 1>(Tfor);
      stan::math::fill(k_p, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> k2_p;
      k2_p = Eigen::Matrix<double, -1, 1>(Tfor);
      stan::math::fill(k2_p, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> g_p;
      g_p = Eigen::Matrix<double, -1, 1>(Tfor);
      stan::math::fill(g_p, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> gf;
      gf = Eigen::Matrix<double, -1, 1>(gf_1dim__);
      stan::math::fill(gf, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> mufor;
      mufor = Eigen::Matrix<double, -1, 1>(L);
      stan::math::fill(mufor, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> log_lik;
      log_lik = Eigen::Matrix<double, -1, 1>(log_lik_1dim__);
      stan::math::fill(log_lik, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> log_lik2;
      log_lik2 = Eigen::Matrix<double, -1, 1>(log_lik2_1dim__);
      stan::math::fill(log_lik2, std::numeric_limits<double>::quiet_NaN());
      
      int pos;
      pos = std::numeric_limits<int>::min();
      
      current_statement__ = 25;
      pos = 1;
      int pos2;
      pos2 = std::numeric_limits<int>::min();
      
      current_statement__ = 26;
      pos2 = 1;
      int pos3;
      pos3 = std::numeric_limits<int>::min();
      
      current_statement__ = 27;
      pos3 = 1;
      current_statement__ = 28;
      assign(k_p, cons_list(index_uni(1), nil_index_list()),
        ((c1 + k[(T - 1)]) + (sigma[(1 - 1)] * normal_rng(0, 1, base_rng__))),
        "assigning variable k_p");
      current_statement__ = 30;
      for (int t = 2; t <= Tfor; ++t) {
        current_statement__ = 29;
        assign(k_p, cons_list(index_uni(t), nil_index_list()),
          ((c1 + k_p[((t - 1) - 1)]) +
            (sigma[(1 - 1)] * normal_rng(0, 1, base_rng__))),
          "assigning variable k_p");}
      current_statement__ = 31;
      assign(k2_p, cons_list(index_uni(1), nil_index_list()),
        (((c2 + k2[(T - 1)]) +
           (((rho * sigma[(2 - 1)]) / sigma[(1 - 1)]) *
             ((k_p[(1 - 1)] - c1) - k[(T - 1)]))) +
          ((sigma[(2 - 1)] * stan::math::sqrt((1 - square(rho)))) *
            normal_rng(0, 1, base_rng__))), "assigning variable k2_p");
      current_statement__ = 33;
      for (int t = 2; t <= Tfor; ++t) {
        current_statement__ = 32;
        assign(k2_p, cons_list(index_uni(t), nil_index_list()),
          (((c2 + k2_p[((t - 1) - 1)]) +
             (((rho * sigma[(2 - 1)]) / sigma[(1 - 1)]) *
               ((k_p[(t - 1)] - c1) - k_p[((t - 1) - 1)]))) +
            ((sigma[(2 - 1)] * stan::math::sqrt((1 - square(rho)))) *
              normal_rng(0, 1, base_rng__))), "assigning variable k2_p");}
      current_statement__ = 34;
      assign(g_p, cons_list(index_uni(1), nil_index_list()),
        (((psi * g[(C - 1)]) + (psi2 * g[((C - 1) - 1)])) +
          (sigma[(3 - 1)] * normal_rng(0, 1, base_rng__))),
        "assigning variable g_p");
      current_statement__ = 35;
      assign(g_p, cons_list(index_uni(2), nil_index_list()),
        (((psi * g_p[(1 - 1)]) + (psi2 * g[(C - 1)])) +
          (sigma[(3 - 1)] * normal_rng(0, 1, base_rng__))),
        "assigning variable g_p");
      current_statement__ = 37;
      for (int t = 3; t <= Tfor; ++t) {
        current_statement__ = 36;
        assign(g_p, cons_list(index_uni(t), nil_index_list()),
          (((psi * g_p[((t - 1) - 1)]) + (psi2 * g_p[((t - 2) - 1)])) +
            (sigma[(3 - 1)] * normal_rng(0, 1, base_rng__))),
          "assigning variable g_p");}
      current_statement__ = 38;
      assign(gf, nil_index_list(), append_row(g, g_p),
        "assigning variable gf");
      current_statement__ = 78;
      if (logical_eq(family, 0)) {
        current_statement__ = 65;
        for (int t = 1; t <= Tfor; ++t) {
          current_statement__ = 64;
          for (int x = 1; x <= J; ++x) {
            current_statement__ = 61;
            assign(mufor, cons_list(index_uni(pos), nil_index_list()),
              ((k_p[(t - 1)] + ((age[(x - 1)] - mean(age)) * k2_p[(t - 1)]))
                + gf[((((T + t) - x) + J) - 1)]), "assigning variable mufor");
            current_statement__ = 62;
            pos = (pos + 1);}}
        current_statement__ = 66;
        assign(mufor, nil_index_list(),
          stan::math::exp(stan::model::deep_copy(mufor)),
          "assigning variable mufor");
        current_statement__ = 71;
        for (int t = 1; t <= T; ++t) {
          current_statement__ = 70;
          for (int x = 1; x <= J; ++x) {
            current_statement__ = 67;
            assign(log_lik, cons_list(index_uni(pos2), nil_index_list()),
              poisson_log_lpmf<false>(d[(pos2 - 1)],
                (((input_offset[(pos2 - 1)] + k[(t - 1)]) +
                   ((age[(x - 1)] - mean(age)) * k2[(t - 1)])) +
                  g[(((t - x) + J) - 1)])), "assigning variable log_lik");
            current_statement__ = 68;
            pos2 = (pos2 + 1);}}
        current_statement__ = 76;
        for (int t = 1; t <= Tval; ++t) {
          current_statement__ = 75;
          for (int x = 1; x <= J; ++x) {
            current_statement__ = 72;
            assign(log_lik2, cons_list(index_uni(pos3), nil_index_list()),
              poisson_log_lpmf<false>(dval[(pos3 - 1)],
                (((offset2[(pos3 - 1)] + k_p[(t - 1)]) +
                   ((age[(x - 1)] - mean(age)) * k2_p[(t - 1)])) +
                  gf[((((T + t) - x) + J) - 1)])),
              "assigning variable log_lik2");
            current_statement__ = 73;
            pos3 = (pos3 + 1);}}
      } else {
        current_statement__ = 60;
        if (logical_gt(family, 0)) {
          current_statement__ = 48;
          for (int t = 1; t <= Tfor; ++t) {
            current_statement__ = 47;
            for (int x = 1; x <= J; ++x) {
              current_statement__ = 45;
              if (logical_gt(
                    stan::math::abs(
                      ((k_p[(t - 1)] +
                         ((age[(x - 1)] - mean(age)) * k2_p[(t - 1)])) +
                        gf[((((T + t) - x) + J) - 1)])), 15)) {
                current_statement__ = 42;
                assign(mufor, cons_list(index_uni(pos), nil_index_list()), 0,
                  "assigning variable mufor");
                current_statement__ = 43;
                pos = (pos + 1);
              } else {
                current_statement__ = 39;
                assign(mufor, cons_list(index_uni(pos), nil_index_list()),
                  gamma_rng(phi,
                    (phi /
                      stan::math::exp(
                        ((k_p[(t - 1)] +
                           ((age[(x - 1)] - mean(age)) * k2_p[(t - 1)])) +
                          gf[((((T + t) - x) + J) - 1)]))), base_rng__),
                  "assigning variable mufor");
                current_statement__ = 40;
                pos = (pos + 1);
              }}}
          current_statement__ = 53;
          for (int t = 1; t <= T; ++t) {
            current_statement__ = 52;
            for (int x = 1; x <= J; ++x) {
              current_statement__ = 49;
              assign(log_lik, cons_list(index_uni(pos2), nil_index_list()),
                neg_binomial_2_log_lpmf<false>(d[(pos2 - 1)],
                  (((input_offset[(pos2 - 1)] + k[(t - 1)]) +
                     ((age[(x - 1)] - mean(age)) * k2[(t - 1)])) +
                    g[(((t - x) + J) - 1)]), phi),
                "assigning variable log_lik");
              current_statement__ = 50;
              pos2 = (pos2 + 1);}}
          current_statement__ = 58;
          for (int t = 1; t <= Tval; ++t) {
            current_statement__ = 57;
            for (int x = 1; x <= J; ++x) {
              current_statement__ = 54;
              assign(log_lik2, cons_list(index_uni(pos3), nil_index_list()),
                neg_binomial_2_log_lpmf<false>(dval[(pos3 - 1)],
                  (((offset2[(pos3 - 1)] + k_p[(t - 1)]) +
                     ((age[(x - 1)] - mean(age)) * k2_p[(t - 1)])) +
                    gf[((((T + t) - x) + J) - 1)]), phi),
                "assigning variable log_lik2");
              current_statement__ = 55;
              pos3 = (pos3 + 1);}}
        } 
      }
      for (int sym1__ = 1; sym1__ <= Tfor; ++sym1__) {
        vars__.emplace_back(k_p[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= Tfor; ++sym1__) {
        vars__.emplace_back(k2_p[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= Tfor; ++sym1__) {
        vars__.emplace_back(g_p[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= gf_1dim__; ++sym1__) {
        vars__.emplace_back(gf[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= L; ++sym1__) {
        vars__.emplace_back(mufor[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= log_lik2_1dim__; ++sym1__) {
        vars__.emplace_back(log_lik2[(sym1__ - 1)]);}
      vars__.emplace_back(pos);
      vars__.emplace_back(pos2);
      vars__.emplace_back(pos3);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<double> aux;
      aux = std::vector<double>(aux_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      assign(aux, nil_index_list(), context__.vals_r("aux"),
        "assigning variable aux");
      std::vector<double> aux_free__;
      aux_free__ = std::vector<double>(aux_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= aux_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(aux_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(aux[(sym1__ - 1)], 0),
          "assigning variable aux_free__");}
      double c1;
      c1 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      c1 = context__.vals_r("c1")[(1 - 1)];
      double c2;
      c2 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      c2 = context__.vals_r("c2")[(1 - 1)];
      std::vector<double> sigma;
      sigma = std::vector<double>(3, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      assign(sigma, nil_index_list(), context__.vals_r("sigma"),
        "assigning variable sigma");
      std::vector<double> sigma_free__;
      sigma_free__ = std::vector<double>(3, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
        current_statement__ = 4;
        assign(sigma_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigma[(sym1__ - 1)], 0),
          "assigning variable sigma_free__");}
      Eigen::Matrix<double, -1, 1> k;
      k = Eigen::Matrix<double, -1, 1>(T);
      stan::math::fill(k, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> k_flat__;
        current_statement__ = 5;
        assign(k_flat__, nil_index_list(), context__.vals_r("k"),
          "assigning variable k_flat__");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
          current_statement__ = 5;
          assign(k, cons_list(index_uni(sym1__), nil_index_list()),
            k_flat__[(pos__ - 1)], "assigning variable k");
          current_statement__ = 5;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> k2;
      k2 = Eigen::Matrix<double, -1, 1>(T);
      stan::math::fill(k2, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> k2_flat__;
        current_statement__ = 6;
        assign(k2_flat__, nil_index_list(), context__.vals_r("k2"),
          "assigning variable k2_flat__");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
          current_statement__ = 6;
          assign(k2, cons_list(index_uni(sym1__), nil_index_list()),
            k2_flat__[(pos__ - 1)], "assigning variable k2");
          current_statement__ = 6;
          pos__ = (pos__ + 1);}
      }
      double rho;
      rho = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      rho = context__.vals_r("rho")[(1 - 1)];
      double rho_free__;
      rho_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      rho_free__ = stan::math::lub_free(rho, -1, 1);
      double psi;
      psi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      psi = context__.vals_r("psi")[(1 - 1)];
      double psi2;
      psi2 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      psi2 = context__.vals_r("psi2")[(1 - 1)];
      Eigen::Matrix<double, -1, 1> gs;
      gs = Eigen::Matrix<double, -1, 1>(gs_1dim__);
      stan::math::fill(gs, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> gs_flat__;
        current_statement__ = 10;
        assign(gs_flat__, nil_index_list(), context__.vals_r("gs"),
          "assigning variable gs_flat__");
        current_statement__ = 10;
        pos__ = 1;
        current_statement__ = 10;
        for (int sym1__ = 1; sym1__ <= gs_1dim__; ++sym1__) {
          current_statement__ = 10;
          assign(gs, cons_list(index_uni(sym1__), nil_index_list()),
            gs_flat__[(pos__ - 1)], "assigning variable gs");
          current_statement__ = 10;
          pos__ = (pos__ + 1);}
      }
      for (int sym1__ = 1; sym1__ <= aux_1dim__; ++sym1__) {
        vars__.emplace_back(aux_free__[(sym1__ - 1)]);}
      vars__.emplace_back(c1);
      vars__.emplace_back(c2);
      for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
        vars__.emplace_back(sigma_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        vars__.emplace_back(k[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        vars__.emplace_back(k2[(sym1__ - 1)]);}
      vars__.emplace_back(rho_free__);
      vars__.emplace_back(psi);
      vars__.emplace_back(psi2);
      for (int sym1__ = 1; sym1__ <= gs_1dim__; ++sym1__) {
        vars__.emplace_back(gs[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("aux");
    names__.emplace_back("c1");
    names__.emplace_back("c2");
    names__.emplace_back("sigma");
    names__.emplace_back("k");
    names__.emplace_back("k2");
    names__.emplace_back("rho");
    names__.emplace_back("psi");
    names__.emplace_back("psi2");
    names__.emplace_back("gs");
    names__.emplace_back("g");
    names__.emplace_back("phi");
    names__.emplace_back("k_p");
    names__.emplace_back("k2_p");
    names__.emplace_back("g_p");
    names__.emplace_back("gf");
    names__.emplace_back("mufor");
    names__.emplace_back("log_lik");
    names__.emplace_back("log_lik2");
    names__.emplace_back("pos");
    names__.emplace_back("pos2");
    names__.emplace_back("pos3");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(aux_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(3)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(gs_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(C)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(Tfor)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(Tfor)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(Tfor)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(gf_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(L)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(log_lik_1dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(log_lik2_1dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= aux_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "aux" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "c1");
    param_names__.emplace_back(std::string() + "c2");
    for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "k" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "k2" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "rho");
    param_names__.emplace_back(std::string() + "psi");
    param_names__.emplace_back(std::string() + "psi2");
    for (int sym1__ = 1; sym1__ <= gs_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gs" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "g" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "phi");
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= Tfor; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "k_p" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= Tfor; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "k2_p" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= Tfor; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "g_p" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= gf_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "gf" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= L; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mufor" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= log_lik2_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik2" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "pos");
      param_names__.emplace_back(std::string() + "pos2");
      param_names__.emplace_back(std::string() + "pos3");
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= aux_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "aux" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "c1");
    param_names__.emplace_back(std::string() + "c2");
    for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "k" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "k2" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "rho");
    param_names__.emplace_back(std::string() + "psi");
    param_names__.emplace_back(std::string() + "psi2");
    for (int sym1__ = 1; sym1__ <= gs_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gs" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "g" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "phi");
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= Tfor; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "k_p" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= Tfor; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "k2_p" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= Tfor; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "g_p" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= gf_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "gf" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= L; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mufor" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= log_lik2_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik2" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "pos");
      param_names__.emplace_back(std::string() + "pos2");
      param_names__.emplace_back(std::string() + "pos3");
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"aux\",\"type\":{\"name\":\"array\",\"length\":" << aux_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"c1\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"c2\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"array\",\"length\":" << 3 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"k\",\"type\":{\"name\":\"vector\",\"length\":" << T << "},\"block\":\"parameters\"},{\"name\":\"k2\",\"type\":{\"name\":\"vector\",\"length\":" << T << "},\"block\":\"parameters\"},{\"name\":\"rho\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"psi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"psi2\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"gs\",\"type\":{\"name\":\"vector\",\"length\":" << gs_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"g\",\"type\":{\"name\":\"vector\",\"length\":" << C << "},\"block\":\"transformed_parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"k_p\",\"type\":{\"name\":\"vector\",\"length\":" << Tfor << "},\"block\":\"generated_quantities\"},{\"name\":\"k2_p\",\"type\":{\"name\":\"vector\",\"length\":" << Tfor << "},\"block\":\"generated_quantities\"},{\"name\":\"g_p\",\"type\":{\"name\":\"vector\",\"length\":" << Tfor << "},\"block\":\"generated_quantities\"},{\"name\":\"gf\",\"type\":{\"name\":\"vector\",\"length\":" << gf_1dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"mufor\",\"type\":{\"name\":\"vector\",\"length\":" << L << "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << log_lik_1dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik2\",\"type\":{\"name\":\"vector\",\"length\":" << log_lik2_1dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"pos\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"pos2\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"pos3\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"aux\",\"type\":{\"name\":\"array\",\"length\":" << aux_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"c1\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"c2\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"array\",\"length\":" << 3 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"k\",\"type\":{\"name\":\"vector\",\"length\":" << T << "},\"block\":\"parameters\"},{\"name\":\"k2\",\"type\":{\"name\":\"vector\",\"length\":" << T << "},\"block\":\"parameters\"},{\"name\":\"rho\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"psi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"psi2\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"gs\",\"type\":{\"name\":\"vector\",\"length\":" << gs_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"g\",\"type\":{\"name\":\"vector\",\"length\":" << C << "},\"block\":\"transformed_parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"k_p\",\"type\":{\"name\":\"vector\",\"length\":" << Tfor << "},\"block\":\"generated_quantities\"},{\"name\":\"k2_p\",\"type\":{\"name\":\"vector\",\"length\":" << Tfor << "},\"block\":\"generated_quantities\"},{\"name\":\"g_p\",\"type\":{\"name\":\"vector\",\"length\":" << Tfor << "},\"block\":\"generated_quantities\"},{\"name\":\"gf\",\"type\":{\"name\":\"vector\",\"length\":" << gf_1dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"mufor\",\"type\":{\"name\":\"vector\",\"length\":" << L << "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << log_lik_1dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik2\",\"type\":{\"name\":\"vector\",\"length\":" << log_lik2_1dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"pos\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"pos2\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"pos3\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_M6model_namespace::model_M6model;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_M6model_namespace::profiles__;
}
#endif
#endif
