% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphing_functions.R
\name{plotDensitySplitByDuration}
\alias{plotDensitySplitByDuration}
\title{Plot Density Graph, Splitting Groups by Duration}
\usage{
plotDensitySplitByDuration(
  data_path,
  graph_title = "Call Distribution Grouped by Duration (s)",
  graph_subtitle = "Duration groups are rounded to the nearest 0.01 second.",
  chosen_group = c()
)
}
\arguments{
\item{data_path}{The full path to the Excel file exported from DeepSqueak}

\item{graph_title}{The title for the graph (there is a default title if not specified)}

\item{graph_subtitle}{The subtitle for the graph (there is a default subtitle if not specified)}

\item{chosen_group}{Specifying a particular group to be highlighted in the graph}
}
\value{
A ggplot2 visualization of the density graph shown in the viewer window, which can be manually exported.
}
\description{
Plots a density graph, separating each duration group into a separate plot in the figure.
}
\examples{
\dontrun{plotDensitySplitByDuration(
  data_path = "inst/extdata/Example_Mouse_Data.xlsx",
  graph_title = "myTitle", graph_subtitle = "myDescription"
)}

}
