% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSpatialCoor.R
\name{plotSpatialPropAll}
\alias{plotSpatialPropAll}
\title{Plot predicted proportions for all cell types using spatial coordinates of
spots}
\usage{
plotSpatialPropAll(
  object,
  index.st,
  colors = "blues",
  set = "raw",
  size.point = 0.1,
  title = NULL,
  nrow = NULL,
  ncol = NULL,
  theme = NULL
)
}
\arguments{
\item{object}{A \code{\linkS4class{SpatialDDLS}} object.}

\item{index.st}{Index of the spatial transcriptomics data to be plotted. It
can be either a position or a name if a named list was provided.}

\item{colors}{Color scale to be used. It can be \code{"blues"} or
\code{"spectral"} (the former by default).}

\item{set}{If results were simplified (see \code{?\link{deconvSpatialDDLS}}
for details), what results to plot (\code{raw} by default).}

\item{size.point}{Size of points (0.1 by default).}

\item{title}{Title of plot.}

\item{nrow}{Number of rows in the split plot.}

\item{ncol}{Number of columns in the split plot.}

\item{theme}{\pkg{ggplot2} theme.}
}
\value{
A ggplot object.
}
\description{
Color spots on the spatial coordinates plot according to their predicted cell
type proportions. All cell types are represented together using the same
color scale from 0 to 1.
}
\seealso{
\code{\link{plotSpatialProp}} \code{\link{deconvSpatialDDLS}}
\code{\link{trainDeconvModel}}
}
