% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moduleMetadata.R
\name{moduleVersion}
\alias{moduleVersion}
\alias{moduleVersion,character,character,missing-method}
\alias{moduleVersion,character,missing,missing-method}
\alias{moduleVersion,character,missing,simList-method}
\title{Parse and extract a module's version}
\usage{
moduleVersion(module, path, sim, envir = NULL)

\S4method{moduleVersion}{character,character,missing}(module, path, envir)

\S4method{moduleVersion}{character,missing,missing}(module, envir)

\S4method{moduleVersion}{character,missing,simList}(module, sim, envir)
}
\arguments{
\item{module}{Character string. Your module's name.}

\item{path}{Character string specifying the file path to modules directory.
Default is to use the \code{spades.modulePath} option.}

\item{sim}{A \code{simList} simulation object, generally produced by \code{simInit}.}

\item{envir}{Optional environment in which to store parsed code. This may be
useful if the same file is being parsed multiple times. This
function will check in that environment for the parsed file before
parsing again. If the \code{envir} is transient, then this will have no effect.}
}
\value{
\code{numeric_version} indicating the module's version.
}
\description{
Parse and extract a module's version
}
\examples{
# using filepath
path <- getSampleModules(tempdir())
moduleVersion("caribouMovement", path)

# using simList
options("spades.useRequire" = FALSE)
if (require("SpaDES.tools", quietly = TRUE)) {
   mySim <- simInit(
      times = list(start = 2000.0, end = 2002.0, timeunit = "year"),
      params = list(
        .globals = list(stackName = "landscape", burnStats = "nPixelsBurned")
      ),
      modules = list("caribouMovement"),
      paths = list(modulePath = path)
   )
   moduleVersion("caribouMovement", sim = mySim)
}
}
\seealso{
\code{\link[=moduleMetadata]{moduleMetadata()}}
}
\author{
Alex Chubaty
}
