% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CollectDataYoutube.R
\name{CollectDataYoutube}
\alias{CollectDataYoutube}
\title{Note: this function is DEPRECATED and will be removed in a future release.
Please use the \code{Collect} function}
\usage{
CollectDataYoutube(videoIDs, apiKeyYoutube, verbose, writeToFile, maxComments)
}
\arguments{
\item{videoIDs}{character vector, specifying one or more YouTube video IDs.
For example, if the video URL is
'https://www.youtube.com/watch?v=W2GZFeYGU3s', then use
\code{videoIDs='W2GZFeYGU3s'}. For multiple videos, the function
\code{GetYoutubeVideoIDs} can be used to create a vector object suitable as
input for \code{videoIDs}.}

\item{apiKeyYoutube}{character string, specifying the Google Developer API
Key used for authentication.}

\item{verbose}{logical. If \code{TRUE} then this function will output
runtime information to the console as it computes. Useful diagnostic tool
for long computations. Default is \code{FALSE}.}

\item{writeToFile}{logical. If \code{TRUE} then the data is saved to file in
current working directory (CSV format), with filename denoting current
system time. Default is \code{FALSE}.}

\item{maxComments}{numeric integer, specifying how many 'top-level' comments
to collect from each video. This value *does not* take into account 'reply'
comments (i.e. replies to top-level comments), therefore the total number of
comments collected may be higher than \code{maxComments}. By default this
function attempts to collect all comments.}
}
\value{
A data frame object of class \code{dataSource.youtube} that can be
used for creating unimodal networks (\code{CreateActorNetwork}).
}
\description{
Collect YouTube comments data for generating different types of networks
}
\details{
This function collects YouTube comments data for one or more YouTube videos.
It structures the data into a data frame of class \code{dataSource.youtube},
ready for creating networks for further analysis.

\code{CollectDataYoutube} collects public comments from YouTube videos,
using the YouTube API.

The function then finds and maps the relationships of YouTube users who have
interacted with each other (i.e. user i has replied to user j or mentioned
user j in a comment) and structures these relationships into a data frame
format suitable for creating unimodal networks (\code{CreateActorNetwork}).

For multiple videos, the user may wish to use the function
\code{GetYoutubeVideoIDs}, which creates a character vector of video IDs
from a plain text file of YouTube video URLs, which can then be used for the
\code{videoIDs} argument of the function \code{CollectDataYoutube}.
}
\note{
Currently supported network types:

- unimodal 'actor' network; \code{CreateActorNetwork}

Data generated using this function is *not* suitable for dynamic networks.
Dynamic YouTube comments networks are not currently implemented in the
SocialMediaLab package. This will be implemented in a future release.

Note on \code{maxComments} argument: Due to quirks/specifications of the
Google API, it is currently not possible to specify the exact number of
comments to return from the API using \code{maxResults} argument (i.e.
including comments that are replies to top-level comments). Therefore, the
number of comments collected is usually somewhat greater than
\code{maxComments}, if a value is specified for this argument. For example,
if a video contains 10 top-level comments, and one of these top-level
comments has 5 'child' or reply comments, then the total number of comments
collected will be equal to 15. Currently, the user must 'guesstimate' the
\code{maxResults} value, to collect a number of comments in the order of
what they require.
}
\examples{

\dontrun{
  # Use your own Google Developer API Key here:
  myApiKey <- "1234567890"

  # Authenticate with the Google API
  apiKeyYoutube <- AuthenticateWithYoutubeAPI(apiKeyYoutube=myApiKey)

  # Generate a vector of YouTube video IDs to collect data from
  # (or use the function `GetYoutubeVideoIDs` to automatically
  # generate from a plain text file of video URLs)
  videoIDs <- c("W2GZFeYGU3s","mL27TAJGlWc")

  # Collect the data using function `CollectDataYoutube`
  myYoutubeData <- CollectDataYoutube(videoIDs,apiKeyYoutube,writeToFile=FALSE)

  # Create an 'actor' network using the function `CreateActorNetwork`
  g_actor_youtube <- CreateActorNetwork(myYoutubeData)
}
}
\author{
Timothy Graham <timothy.graham3@uq.net.au> & Robert Ackland
<robert.ackland@anu.edu.au>
}
\seealso{
\code{AuthenticateWithYoutubeAPI} must be run first or no data will
be collected.
}
\keyword{SNA}
\keyword{data}
\keyword{mining}
\keyword{youtube}

