% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.idm.R
\name{summary.idm}
\alias{summary.idm}
\title{Summary of a fitted illness-death model}
\usage{
\method{summary}{idm}(object, conf.int = 0.95, digits = 4, pvalDigits = 4, eps = 0.0001, ...)
}
\arguments{
\item{object}{a \code{idmSplines} object, i.e., the result of a call to the
\code{\link{idm}} function with \code{intensities}="Splines".}

\item{conf.int}{The level of confidence for the hazard ratios. The default is \code{0.95}.}

\item{digits}{number of digits to print.}

\item{pvalDigits}{number of digits to print for p-values.}

\item{eps}{convergence criterion used for p-values.}

\item{\dots}{other unusued arguments.}
}
\value{
No return value.
}
\description{
Summarize the event history data of an illness-death regression model
and show regression coefficients for transition intensities
}
\examples{

\donttest{
library(prodlim)
data(Paq1000)
fit.splines <-  idm(formula02=Hist(time=t,event=death,entry=e)~certif,
		formula01=Hist(time=list(l,r),event=dementia)~certif,
                formula12=~1,
                method="Splines",
		data=Paq1000)
summary(fit.splines) 
}
}
\seealso{
\code{\link{idm}}, \code{\link{print.idm}},
\code{\link{plot.idm}}
}
\author{
R: Celia Touraine <Celia.Touraine@isped.u-bordeaux2.fr> Fortran:
Pierre Joly <Pierre.Joly@isped.u-bordeaux2.fr>
}
\keyword{methods}
