% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shr.R
\name{shr}
\alias{shr}
\title{Fit a survival model}
\usage{
shr(
  formula,
  data,
  eps = c(5, 5, 3),
  n.knots = 7,
  knots = "equidistant",
  CV = FALSE,
  kappa = 10000,
  conf.int = 0.95,
  maxiter = 200,
  method = "Weib",
  print.iter = FALSE,
  na.action = na.omit
)
}
\arguments{
\item{formula}{a formula object with the response on the left hand side
and the terms on the right hand side. The
response must be a survival object or Hist object as returned by
the \code{'Surv'} or \code{'Hist'} function.}

\item{data}{a data frame in which to interpret the variables named
in the \code{formula}.}

\item{eps}{a vector of length 3 for the convergence criteria
(criterion for parameters, criterion for likelihood, criterion for
second derivatives). The default is \code{c(5,5,3)} and corresponds to
criteria equals to \code{10^{-5}}, \code{10^{-5}} and \code{10^{-3}}.}

\item{n.knots}{Argument only active for the penalized likelihood approach \code{method="splines"}.
Number of knots for the splines to use to approximate
the hazard function. The default is 7. If \code{knots} are given as a vector this argument is ignored.
The algorithm needs least 5 knots and at most 20 knots.}

\item{knots}{Argument only active for the penalized likelihood approach \code{method="splines"}.
There are three ways to control the placement of the knots between the smallest and the largest
of all time points:
\describe{
 \item{\code{knots="equidistant"}}{Knots are placed with same distance on the time scale.}
 \item{\code{knots="quantiles"}}{Knots are placed such that the number of observations is roughly the same between knots.}
\item{knots=list()}{List of length 3. The list elements are the actual placements
(timepoints) of the knots for the M-spline.}
}
The algorithm reuqires at least 5 knots and allows no more than 20 knots.}

\item{CV}{binary variable equals to 1 when search (by approximated
cross validation) of the smoothing parameter kappa and 0
otherwise. Argument for the penalized likelihood approach. The
default is 0.}

\item{kappa}{Argument only active for the penalized likelihood approach \code{method="splines"}.
A positive number (smoothing parameter) 
If CV=1 the value is used as a starting value 
for a cross validation search to optimize \code{kappa}.}

\item{conf.int}{Level of confidence pointwise confidence intervals of the survival and hazard functions, i.e.,
a value between 0 and 1, the default is \code{0.95}.
The default is also used when \code{conf.int=TRUE}.
To avoid computation of confidence intervals, set \code{conf.int} to FALSE or NULL.}

\item{maxiter}{maximum number of iterations. The default is 200.}

\item{method}{type of estimation method: "Splines" for a penalized
likelihood approach with approximation of the hazard function by
M-splines, "Weib" for a parametric approach with a Weibull
distribution on the hazard function. Default is \code{"Weib"}.}

\item{print.iter}{boolean parameter. Equals to \code{TRUE} to print
the likelihood during the iteration process, \code{FALSE}
otherwise. Default is \code{FALSE}. This option is not running on
Windows.}

\item{na.action}{how NAs are treated. The default is first, any
na.action attribute of data, second a na.action setting of options,
and third 'na.fail' if that is unset. The 'factory-fresh' default
is na.omit. Another possible value is NULL.}
}
\value{
\describe{
\item{call}{} \item{coef}{regression parameters.}
\item{loglik}{vector containing the log-likelihood without and with covariate.}
\item{modelPar}{Weibull parameters.}
\item{N}{number of subjects.}
\item{NC}{number of covariates.}
\item{nevents}{number of events.}
\item{modelResponse}{model response: \code{Hist} or \code{Surv} object.}
\item{converged}{integer equal to 1 when the model converged, 2, 3 or 4 otherwise.}
\item{time}{times for which survival and hazard functions have been evaluated for plotting.}
\item{hazard}{matched values of the hazard function.}
\item{lowerHazard}{lower confidence limits for hazard function.}
\item{upperHazard}{upper confidence limits for hazard function.}
\item{surv}{matched values of the survival function.}
\item{lowerSurv}{lower confidence limits for survival function.}
\item{upperSurv}{upper confidence limits for survival function.}
\item{RR}{vector of relative risks.}
\item{V}{variance-covariance matrix.}
\item{se}{standard errors.}
\item{knots}{knots of the M-splines estimate of the hazard function.}
\item{nknots}{number of knots.}
\item{CV}{a binary variable equals to 1 when search of the smoothing parameter
         \link{kappa} by approximated cross-validation, 1 otherwise. The default is 0.}
\item{niter}{number of iterations.}
\item{cv}{vector containing the convergence criteria.}
\item{na.action}{observations deleted if missing values.}
}
}
\description{
Fit a survival model using either a semi-parametric approach (penalized
likelihood with an approximation of the hazard function by linear
combination of M-splines) or a parametric approach (specifying a Weibull
distribution on the hazard function). Left-truncated, right-censored, and
interval-censored data are allowed.
}
\details{
The estimated parameters are obtained using the robust Marquardt algorithm
(Marquardt, 1963) which is a combination between a Newton-Raphson algorithm
and a steepest descent algorithm.
}
\examples{

# Weibull survival model
library(prodlim)
data(testdata)
fit.su <- shr(Hist(time=list(l,r),id)~cov,data=testdata) 
fit.su
summary(fit.su)
\donttest{
shr.spline <- shr(Hist(time=list(l,r),id)~cov,data=testdata,method="splines",n.knots=6)
shr.spline
shr.spline.q <- shr(Hist(time=list(l,r),id)~cov,data=testdata,
                    method="splines",n.knots=6,knots="quantiles")
plot(shr.spline.q)

## manual placement of knots
shr.spline.man <- shr(Hist(time=list(l,r),id)~cov,data=testdata,method="splines",knots=seq(0,7,1))
}
}
\references{
D. Marquardt (1963). An algorithm for least-squares estimation
of nonlinear parameters.  \emph{SIAM Journal of Applied Mathematics},
431-441.
}
\seealso{
\code{\link{shr}}, \code{\link{print.shr}},
\code{\link{summary.shr}}, \code{\link{print.shr}},
}
\author{
R: Celia Touraine \email{celia.touraine@icm.unicancer.fr} Fortran:
Pierre Joly \email{Pierre.Joly@isped.u-bordeaux2.fr}
}
\keyword{methods}
