% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_exp_outliers.R
\name{ExpOutliers}
\alias{ExpOutliers}
\title{Univariate outlier analysis}
\usage{
ExpOutliers(data, varlist = NULL, method = "boxplot",
  treatment = NULL, capping = c(0.05, 0.95), outflag = FALSE)
}
\arguments{
\item{data}{dataframe or matrix}

\item{varlist}{list of numeric variable to perform the univariate outlier analysis}

\item{method}{detect outlier method boxplot or 3xStDev}

\item{treatment}{treating outlier value by mean or median. default NULL}

\item{capping}{default LL = 0.05 & UL = 0.95cap the outlier value by replacing those observations outside the lower limit with the value of 5th percentile and above the upper limit, with the value of 95th percentile value}

\item{outflag}{add extreme value flag variable into output data}
}
\value{
Outlier summary includes

\itemize{
  \item \code{Num of outliers} is Number of outlier in each variable
  \item \code{Lower bound} is Q1 minus 1.5x IQR for boxplot; Mean minus 3x StdDev for Standard Deviation method
  \item \code{Upper bound} is Q3 plus 1.5x IQR for boxplot; Mean plus 3x StdDev for Standard Deviation method
  \item \code{Lower cap} is Lower percentile capping value
  \item \code{Upper cap} is Upper percentile capping value
}
}
\description{
this function will run univariate outlier analysis based on boxplot or SD method. The function returns the summary of oultlier for selected numeric features and adding new features if there is any outliers
}
\details{
this function provides both summary of the outlier variable and data

Univariate outlier analysis method
\itemize{
  \item \code{boxplot} is If a data value are below (Q1 minus 1.5x IQR) or boxplot lower whisker or above (Q3 plus 1.5x IQR) or boxplot upper whisker then those points are flaged as outlier value
  \item \code{Standard Deviation} is If a data distribution is approximately normal then about 68 percent of the data values lie within one standard deviation of the mean and about 95 percent are within two standard deviations, and about 99.7 percent lie within three standard deviations.  If any data point that is more than 3 times the standard deviation, then those points are flaged as outlier value
}
}
\examples{
ExpOutliers(mtcars, varlist = c("mpg","disp","wt", "qsec"), method = 'BoxPlot',
capping = c(0.1, 0.9), outflag = TRUE)
# Mean imputation or 5th percentile or 95th percentile value capping
ExpOutliers(mtcars, varlist = c("mpg","disp","wt", "qsec"), method = 'BoxPlot',
treatment = "mean", capping = c(0.05, 0.95), outflag = TRUE)

}
