% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Markers_filter_PanglaoDB.R
\name{Markers_filter_PanglaoDB}
\alias{Markers_filter_PanglaoDB}
\title{Create Marker_list from the PanglaoDB database}
\usage{
Markers_filter_PanglaoDB(df, species_input, organ_input)
}
\arguments{
\item{df}{Standardized PanglaoDB database. It is read as data(PanglaoDB)
in the SlimR library.}

\item{species_input}{Species information in PanglaoDB database. The default
input is "Human" or "Mouse".The input can be retrieved by "PanglaoDB_table".
For more information,please refer to https://panglaodb.se/ on PanglaoDB's
official website.}

\item{organ_input}{Organ type information in the PanglaoDB database.
The input can be retrieved by "PanglaoDB_table".For more information,
please refer to https://panglaodb.se/ on PanglaoDB's official website.}
}
\value{
The standardized "Marker_list" in the SlimR package
}
\description{
Create Marker_list from the PanglaoDB database
}
\examples{
PanglaoDB <- SlimR::PanglaoDB
Markers_list_panglaoDB <- Markers_filter_PanglaoDB(
    PanglaoDB,
    species_input = 'Human',
    organ_input = 'GI tract'
    )

}
\seealso{
Other Section_2_Standardized_Markers_List: 
\code{\link{Markers_filter_Cellmarker2}()},
\code{\link{Read_excel_markers}()},
\code{\link{Read_seurat_markers}()}
}
\concept{Section_2_Standardized_Markers_List}
