% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SkeweDF_functions.R
\name{psi_criterion_RGHD_ratio}
\alias{psi_criterion_RGHD_ratio}
\title{Psi Criterion for RGHD parameter ratios}
\usage{
psi_criterion_RGHD_ratio(
  params,
  data,
  m,
  pmf_weight = 0,
  weighted_rt = FALSE,
  left_trunc = 1,
  right_trunc = left_trunc + length(data) - 1
)
}
\arguments{
\item{params}{Vector of parameters for model_fn, not including n. For example, for 2m-RGHD (m=2), params <- c(3, 5, 0.3, 1.5). In this case r1 = 3, r2 = 5, q1/r1 = 0.3, and q2/r2 = 1.5}

\item{data}{Vector of observed values}

\item{m}{m parameter for 2m-RGHD function}

\item{pmf_weight}{Numeric of weight given to probability mass function for generation of Psi Criterion. For example, if pmf_weight <- 0.5, 50 percent of the Psi Criterion value will be attributed to the probability mass function while the other 50 percent will be attributed to the right-tail cumulative distribution function.}

\item{weighted_rt}{Boolean used to determine if the weighted right-tail cumulative distribution function should be used or not.}

\item{left_trunc}{Int used to determine starting index of model to use for optimization}

\item{right_trunc}{Int used to determine ending index of model to use for optimization}
}
\description{
This function generates the Psi Criterion goodness of fit value given an empirical distribution for the 2m-RGHD function. Parameters r and q/r ratios are given, as well as desired weight of pmf and use of the weighted right-tail cumulative distribution function.
}
\examples{
obs_data <- c(100,75,20,1)
parameters <- c(3, 5, 0.3, 1.5)
psi <- psi_criterion_RGHD_ratio(parameters, obs_data, 2)
}
