% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ss.data.batteries}
\alias{ss.data.batteries}
\title{Data for the batteries example}
\format{A data frame with 18 observations on the following 4 variables.
 \describe{
   \item{\code{voltmeter}}{a factor with levels \code{1} \code{2}}
   \item{\code{battery}}{a factor with levels \code{1} \code{2} \code{3}}
   \item{\code{run}}{a factor with levels \code{1} \code{2} \code{3}}
   \item{\code{voltage}}{a numeric vector}
 }}
\source{
See references.
}
\usage{
data(ss.data.batteries)
}
\description{
This is a simulated data set of 18 measurements of the voltage of batteries using different
voltmeters.
}
\note{
This data set is used in chapter 5 of the book ``Six Sigma with R'' (see 
References).
}
\examples{
data(ss.data.batteries)
summary(ss.data.batteries)
plot(voltage~voltmeter, data = ss.data.batteries)

}
\references{
Cano, Emilio L., Moguerza, Javier M. and Redchuk, Andrés. 2012.
\emph{Six Sigma with {R}. Statistical Engineering for Process
  Improvement}, Use R!, vol. 36. Springer, New York.
  \url{http://www.springer.com/statistics/book/978-1-4614-3651-5}.\cr
}
\seealso{
\link{ss.rr}
}
\keyword{data}
\keyword{msa}

