% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiSimReg.R
\name{multi_sim_reg}
\alias{multi_sim_reg}
\title{Similarity regression on multiple \code{y} vectors}
\usage{
multi_sim_reg(ontology, x, y, mc_cores = 1L, return_data_frame = TRUE,
  g = matrix(0, nrow = nrow(y), ncol = ncol(y)), lit_sim_mat = NULL,
  summary_function = summary, ...)
}
\arguments{
\item{ontology}{\code{ontology_index} object.}

\item{x}{List of character vectors of terms IDs.}

\item{y}{Logical matrix of genotypes (typically TRUE for rare genotype, FALSE for common genotype).}

\item{mc_cores}{Number of cores to use - passed to \code{mcmapply} function.}

\item{return_data_frame}{Logical value determining whether to return data.frame.}

\item{g}{Genotype log odds offset per individual.}

\item{lit_sim_mat}{Numeric matrix of prior weights for terms inclusion in phi for each row of \code{y}, where the columns match to those in \code{term_sim_mat}. Thus, must have exactly the same number of rows as \code{y}, and same number of columns as \code{term_sim_mat}. Defaults to 'all equal' (=1).}

\item{summary_function}{Function to apply to the samples generated conditioning on each row of \code{y}.}

\item{...}{Other arguments to be passed to \code{\link{sim_reg}}.}
}
\value{
List or data frame of summarised output of \code{\link{sim_reg}}.
}
\description{
Applies \code{\link{sim_reg}} regression to multiple binary 'genotypes', \code{y}, encoded in a logical matrix having the individual binary genotypes as rows, against the same set of ontological 'phenotypes'. Thus, the individual subject's genotypes occupy the columns of \code{y} and the number of columns is equal to the length of the list of phenotypes \code{x}. The user can supply a function to be applied to the \code{sim_reg_samples} object for each completed inference. Suitable choices for the function include \code{\link{summary}} (default) and \code{identity} (though identity will lead to extremely large objects if there are many rows in the \code{y} matrix); the number of cores to use.
}

