% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choose_gameteFunctions.R
\name{sim_gameteInheritance}
\alias{sim_gameteInheritance}
\title{Simulate inheritance of parental gamete to offspring}
\usage{
sim_gameteInheritance(RV_locus, parent_RValleles, offspring_RVstatus, chrom_map,
  allele_IDs, burn_in = 1000, gamma_params = c(2.63, 2.63/0.5))
}
\arguments{
\item{RV_locus}{Numeric list of length 2. A list containing (1) the chromosome upon which the rare variant resides (2) the position in cM where the rare variant resides.}

\item{parent_RValleles}{Numeric list of length 2. The paternal and maternal alleles at the disease locus (1 = RV inherited, 0 otherwise)}

\item{offspring_RVstatus}{Numeric. 1 if offspring inherits the RV from parent, 0 otherwise.}

\item{chrom_map}{Data.frame.  A data.frame consisting of three columns: column 1 contains the chromosome numbers, column 2 start postion of chromosome (in cM), column 3 end position of chromosome (in cM).}

\item{allele_IDs}{List of length 2. The identification numbers for the respective paternal and maternal alleles of the individual for whom we wish to simulate recombination. (Can accomodate numeric or string entries)}

\item{burn_in}{Numeric. The "burn-in" distance in centiMorgan, as defined by Voorrips and Maliepaard (2012), which is required before simulating the location of the first chiasmata with interference. By default, \code{burn_in = 1000}.
The burn in distance in cM. By default, \code{burn_in = 1000}.}

\item{gamma_params}{Numeric list of length 2. The respective shape and rate parameters of the gamma distribution used to simulate distance between chiasmata.  By default, \code{gamma_params = c(2.63, 2*2.63)}, as discussed in Voorrips and Maliepaard (2012).}
}
\value{
A list containing (1) a list of inherited haplotype codings (2) the chiasmata locations
}
\description{
Simulate inheritance of parental gamete to offspring based on rare variant statuses of parent and offspring.
}
\details{
Here we use the RV statuses of the parent and offspring to determine which of the parental gametes are appropriate options for transmission.  Upon reducing the sample space appropriately we choose from the remaining options with equal probability.
\enumerate{
\item If the parent \strong{is not} a carrier of the rare variant then we choose any of the four gametes with equal probability since the offpring could not have inherited the rare variant from this parent.
\item If the parent \strong{is} a carrier of the rare variant and
\itemize{
\item the offspring \strong{is not} a carrier of the rare variant, we choose with equal probability from the two gametes that \strong{do not} contain the rare variant.
\item the offspring \strong{is} a carrier of the rare variant, we choose with equal probability from the two gametes that \strong{do}contain the rare variant.
}
}
}
\keyword{internal}
