% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVPedSim_Functions.R
\name{ascertain_ped}
\alias{ascertain_ped}
\title{Determine if a pedigree is ascertained}
\usage{
ascertain_ped(ped_file, num_affected, ascertain_span, recall_probs = NULL,
  first_diagnosis = NULL)
}
\arguments{
\item{ped_file}{An object of class \code{ped}. A pedigree generated by \code{sim_ped} or \code{sim_RVped}, or an object created by the function \code{\link{new.ped}}.  See details.}

\item{num_affected}{Numeric.  The minimum number of affected individuals in the pedigree.}

\item{ascertain_span}{Numeric vector of length 2.  The year span of the ascertainment period.  This period represents the range of years during which the proband developed disease and the family would have been ascertained for multiple affected relatives.}

\item{recall_probs}{Numeric. The proband's recall probabilities for relatives, see details.  If not supplied, the default value of four times kinship coefficient between the proband and the relative is used.}

\item{first_diagnosis}{Numeric. The first year that reliable diagnoses can be obtained regarding disease-affection status.  By default, \code{first_diagnosis}\code{ = NULL} so that all diagnoses are considered reliable. See details.}
}
\value{
A list containing the following data frames:

\code{ascertained} Logical.  Indicates if pedigree is ascertained.
}
\description{
Intended priamrily as an internal function, \code{ascertain_ped} checks to see if a pedigree returned by \code{\link{sim_ped}} is ascertained.
}
\keyword{internal}
